\name{plot.warnProb}
\alias{plot.warnProb}
\title{
  Plot for probabilities of posterior weaning parameters
}
\description{
  \code{plot.warnProb} is a plotting utile for quick visualization of the posterior weaning parameters from an object of class \code{"warnProb"}. Results of kernel density estimation for the posteriors are plotted as a form of \code{\link{contour}} with designated parameter ranges.
}
\usage{
\method{plot}{warnProb}(x, is.legend = TRUE, is.contour = TRUE,
  is.image = FALSE, is.prior = FALSE, \dots)
}
\arguments{
  \item{x}{an object of class \code{"warnProb"} generated by \code{\link{warnProb}}.}
  \item{is.legend}{logical; if \code{TRUE} (the default), legend is plotted on the figure.}
  \item{is.contour}{logical; if \code{TRUE} (the default), contour lines corresponding to the probabilirties are plotted with \code{\link{contour}}. Only used if the intended weanig parameter is weaning ages (i.e., \code{weaning.par = "age"} in \code{\link{warnProb}}).}
  \item{is.image}{logical; if \code{TRUE}, grid of gray-scale rectangles with color strength corresponding to the probabilirties is plotted with \code{\link{image}}. The default is \code{FALSE}, and only used if the intended weanig parameter is weaning ages (i.e., \code{weaning.par = "age"} in \code{\link{warnProb}}).}
  \item{is.prior}{logical; if \code{TRUE}, prior density of the paramter is also plotted with dotted line. The default is \code{FALSE}, and only used if the intended weanig parameter is enrichment or weaning food (i.e., \code{weaning.par = "enrich"} or \code{"wnfood"} in \code{\link{warnProb}}).}
  \item{\dots}{additional arguments passed to \code{\link{plot}}.}
}
\details{
  Values on the contour lines indicate relative probabilities based on that of the maximum density estimator.
}
\references{
  Tsutaya, T., and Yoneda, M. (2013). Quantitative reconstruction of weaning ages in archaeological human populations using bone collagen nitrogen isotope ratios and approximate Bayesian computation. \emph{PLoS ONE} \bold{8}, e72327.
}
\seealso{
  \code{\link{WARN}}, \code{\link{warn}}, \code{\link{warnCI}}, \code{\link{warnProb}}, \code{\link{summary.warnProb}}
}
\examples{
## See ?warnProb for examples.
}
\keyword{math}

