% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_voronoi_plot.R
\name{create_voronoi_plot}
\alias{create_voronoi_plot}
\title{Create Voronoi Projection Visualization Plot}
\usage{
create_voronoi_plot(
  data,
  class_column = NULL,
  alternative_class_column = NULL,
  coordinate_columns = NULL,
  case_labels = NULL,
  coord_names = c("Dim1", "Dim2"),
  title = NULL,
  show_labels = FALSE,
  voronoi_alpha = 0.3,
  point_size = 2,
  legend_position = "bottom",
  color_palette = NULL,
  add_grid_lines = FALSE,
  color_points = "primary",
  fill_voronoi = "primary"
)
}
\arguments{
\item{data}{A data frame containing projected data. Must have at least 2 numeric columns.
If more than 2 columns are provided, the first 2 are used as coordinates.}

\item{class_column}{Character string specifying the column name containing class labels,
or a vector of class labels. If NULL, all observations are treated as a single class.
Default: NULL.}

\item{alternative_class_column}{Character string specifying the column name containing
alternative class labels, or a vector of alternative class labels. If NULL, uses
class_column. Default: NULL.}

\item{coordinate_columns}{Character vector of length 2 specifying the column names
to use as coordinates. If NULL, uses the first two numeric columns. Default: NULL.}

\item{case_labels}{Character vector of case labels for individual observations.
If NULL, row numbers are used. Default: NULL.}

\item{coord_names}{Character vector of length 2 specifying names for the coordinate axes.
Default: c("Dim1", "Dim2").}

\item{title}{Character string for plot title. If NULL, no title is added. Default: NULL.}

\item{show_labels}{Logical indicating whether to show case labels on plots. Default: FALSE.}

\item{voronoi_alpha}{Numeric value (0-1) for Voronoi polygon transparency. Default: 0.3.}

\item{point_size}{Numeric value for point size. Default: 2.}

\item{legend_position}{Character string or numeric vector specifying legend position.
Default: "bottom".}

\item{color_palette}{Function or character vector for color palette. If NULL, uses
ggplot2 default colors. Default: NULL.}

\item{add_grid_lines}{Logical indicating whether to add dashed grid lines at origin.
Default: TRUE.}

\item{color_points}{Character string specifying which classification to use for point colors.
Either "primary" (uses class_column) or "alternative" (uses alternative_class_column).
Default: "primary".}

\item{fill_voronoi}{Character string specifying which classification to use for Voronoi fill.
Either "primary" (uses class_column) or "alternative" (uses alternative_class_column).
Default: "primary".}
}
\value{
A ggplot object showing the Voronoi tessellation plot.
}
\description{
Creates a Voronoi tessellation visualization for 2D projected data, showing
class separation through proximity-based regions.
}
\details{
The function creates a Voronoi tessellation visualization for 2D projected data,
particularly useful for displaying results from dimensionality reduction techniques.
Voronoi tessellation divides the plot space into regions based on proximity to data points,
providing an intuitive visualization of class boundaries and decision regions.
}
\examples{
# Basic usage with iris dataset
data <- iris[, c("Sepal.Length", "Petal.Length", "Species")]
plot <- create_voronoi_plot(
  data = data,
  class_column = "Species",
  legend_position = "bottom",
  add_grid_lines = FALSE
)

}