% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VhgGetSubject.R
\name{VhgGetSubject}
\alias{VhgGetSubject}
\title{VhgGetSubject: Process and Count Viral Subjects within Groups}
\usage{
VhgGetSubject(
  file,
  groupby = "best_query",
  remove_identifiers = TRUE,
  include_run_ids = FALSE,
  extract_brackets = FALSE,
  group_unwanted_phyla = NULL
)
}
\arguments{
\item{file}{A data frame containing VirusHunter or VirusGatherer hittable results.}

\item{groupby}{(optional): A character specifying the column containing the groups (default: "best_query").
Note: Gatherer hittables do not have a "best_query" column. Please provide an appropriate column for grouping.}

\item{remove_identifiers}{(optional): if \code{TRUE} (default), removes the identifiers in the ViralRefSeq_subject cells.}

\item{include_run_ids}{(optional): If \code{TRUE} (default is \code{TRUE}), adds a fourth column named \code{run_ids} to the output.
This column contains a comma-separated list of unique identifiers from either the \code{SRA_run} or \code{run_id} column,
aggregated for each combination of group and subject.}

\item{extract_brackets}{(optional): extract content within square brackets [].}

\item{group_unwanted_phyla}{(optional): A character string specifying which group of viral phyla to retain in the analysis.
Valid values are:
\describe{
\item{"rna"}{Retain only the phyla specified for RNA viruses.}
\item{"smalldna"}{Retain only the phyla specified for small DNA viruses.}
\item{"largedna"}{Retain only the phyla specified for large DNA viruses.}
\item{"others"}{Retain only the phyla that match small DNA, Large DNA and RNA viruses.}
}
All other phyla not in the specified group will be grouped into a single category:
"Non-RNA-virus" for \code{"rna"}, "Non-Small-DNA-Virus" for \code{"smalldna"},"Non-Large-DNA-Virus" for \code{"largedna"},or "Other Viruses" for \code{"others"}.}
}
\value{
a processed tibble object.
}
\description{
VhgGetSubject: Process and Count Viral Subjects within Groups
}
\details{
The function \code{VhgGetSubject} counts the number of viral subjects in the \code{ViralRefSeq_subject} column
for each group specified by the \code{groupby} argument.
It returns a tibble with three columns: the first column contains the viral group specified by the \code{groupby} argument,
the second column lists the viral subjects found in that group, and the third column shows how many times each viral subject appears in that group.
}
\examples{

# import data
path <- system.file("extdata", "virushunter.tsv", package = "Virusparies")
file <- ImportVirusTable(path)

# process column and filter for significant groups
file <- VhgPreprocessTaxa(file,taxa_rank = "Family")
file_filtered <- VhgSubsetHittable(file,ViralRefSeq_E_criteria = 1e-5)

subject_df <- VhgGetSubject(file_filtered,groupby = "ViralRefSeq_taxonomy",
remove_identifiers = TRUE)

print(subject_df)

}
\seealso{
VirusHunterGatherer is available here: \url{https://github.com/lauberlab/VirusHunterGatherer}.
}
\author{
Sergej Ruff
}
