% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetRates.R
\name{GetRates}
\alias{GetRates}
\title{Retrieves Period Mortality and Fertility Rates from HMD and HFD for a Selected Country and Selected Year}
\usage{
GetRates(data, refyear)
}
\arguments{
\item{data}{data (the object data_raw, produced by the GetData() function.)}

\item{refyear}{Reference year, which is the year of period data}
}
\value{
A list object with three elements:
\item{ASDR}{Age-specific death rates, by sex for reference year} 
\item{ASFR}{Age-specific birth rates by birth order for reference year}
\item{ratesM}{Matrix of transition rates in format required for mulitstate modelling}
The object returned by the function has three attributes:
\item{country}{Country}
\item{type}{Type of data (period data or cohort data)}
\item{year}{Calendar year for which period death rates are used to complete cohort experience in case of incomplete mortality experience (reference year).}
}
\description{
The rates are retrieved from the life tables and fertility tables included in the raw data downloaded from the HMD and HFD.
}
\examples{
\dontrun{
# Not run because passwords needed
# Input data: data_raw produced by GetData().
rates <- GetRates(data=data_raw,refyear=2021)
}

}
