% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RVineLogLik.R
\name{RVineCDF}
\alias{RVineCDF}
\title{CDF of an R-Vine Copula Model}
\usage{
RVineCDF(data, RVM, N = 1000)
}
\arguments{
\item{data}{An N x d data matrix that specifies where
the CDF shall be evaluated.}

\item{RVM}{An \code{\link[=RVineMatrix]{RVineMatrix()}} object including the
structure and the pair-copula families and parameters.}

\item{N}{Number of points to simulate for the Monte
Carlo integration (default: \code{n = 1000}).}
}
\value{
A vector of length N with the CDF values.
}
\description{
This function calculates the cumulative distribution
function of a d-dimensional R-vine copula.
}
\details{
The cumulative distribution function of a \eqn{d}-dimensional R-vine copula
cannot be expressed in closed form.
However, it can be calculated by numerical integration. The function uses
the \code{\link[=RVineSim]{RVineSim()}} function to
simulate a grid of points and then computes the CDF via Monte Carlo.
}
\examples{
# define 5-dimensional R-vine tree structure matrix
Matrix <- c(
  5, 2, 3, 1, 4,
  0, 2, 3, 4, 1,
  0, 0, 3, 4, 1,
  0, 0, 0, 4, 1,
  0, 0, 0, 0, 1
)
Matrix <- matrix(Matrix, 5, 5)

# define R-vine pair-copula family matrix
family <- c(
  0, 1, 3, 4, 4,
  0, 0, 3, 4, 1,
  0, 0, 0, 4, 1,
  0, 0, 0, 0, 3,
  0, 0, 0, 0, 0
)
family <- matrix(family, 5, 5)

# define R-vine pair-copula parameter matrix
par <- c(
  0, 0.2, 0.9, 1.5, 3.9,
  0, 0, 1.1, 1.6, 0.9,
  0, 0, 0, 1.9, 0.5,
  0, 0, 0, 0, 4.8,
  0, 0, 0, 0, 0
)
par <- matrix(par, 5, 5)

# define second R-vine pair-copula parameter matrix
par2 <- matrix(0, 5, 5)

# define RVineMatrix object
RVM <- RVineMatrix(
  Matrix = Matrix, family = family,
  par = par, par2 = par2,
  names = c("V1", "V2", "V3", "V4", "V5")
)

# compute the CDF at (0.1, 0.2, 0.3, 0.4, 0.5)
RVineCDF(c(0.1, 0.2, 0.3, 0.4, 0.5), RVM)

}
\seealso{
\code{\link[=RVineSim]{RVineSim()}}, \code{\link[=RVineMatrix]{RVineMatrix()}}, \code{\link[=RVineLogLik]{RVineLogLik()}}, \code{\link[=RVinePDF]{RVinePDF()}}
}
\author{
Thibault Vatter
}
