\name{betadist}
\alias{dbetadist}
\alias{pbetadist}
\alias{varbetadist}
\alias{esbetadist}
\title{Beta distribution}
\description{Computes the pdf, cdf, value at risk and expected shortfall for the beta distribution given by
\deqn{\begin{array}{ll}
&\displaystyle
f (x) = \frac {x^{a - 1} (1 - x)^{b - 1}}{B (a, b)},
\\
&\displaystyle
F (x) = I_x (a, b),
\\
&\displaystyle
{\rm VaR}_p (X) = I_p^{-1} (a, b),
\\
&\displaystyle
{\rm ES}_p (X) = \frac {1}{p} \int_0^p I_v^{-1} (a, b) dv
\end{array}}
for \eqn{0 < x < 1}, \eqn{0 < p < 1}, \eqn{a > 0}, the first parameter, and \eqn{b > 0}, the second shape parameter.}
\usage{
dbetadist(x, a=1, b=1, log=FALSE)
pbetadist(x, a=1, b=1, log.p=FALSE, lower.tail=TRUE)
varbetadist(p, a=1, b=1, log.p=FALSE, lower.tail=TRUE)
esbetadist(p, a=1, b=1)
}
\arguments{
  \item{x}{scaler or vector of values at which the pdf or cdf needs to be computed}
  \item{p}{scaler or vector of values at which the value at risk or expected shortfall needs to be computed}
  \item{a}{the value of the first scale parameter, must be positive, the default is 1}
  \item{b}{the value of the second scale parameter, must be positive, the default is 1}
  \item{log}{if TRUE then log(pdf) are returned}
  \item{log.p}{if TRUE then log(cdf) are returned and quantiles are computed for exp(p)}
  \item{lower.tail}{if FALSE then 1-cdf are returned and quantiles are computed for 1-p}
}
\value{An object of the same length as \code{x}, giving the pdf or cdf values computed at \code{x} or an object of the same length as \code{p}, giving the values at risk or expected shortfall computed at \code{p}.}
\references{S. Nadarajah, S. Chan and E. Afuecheta, An R Package for value at risk and expected shortfall, submitted}
\author{Saralees Nadarajah}
\examples{x=runif(10,min=0,max=1)
dbetadist(x)
pbetadist(x)
varbetadist(x)
esbetadist(x)}
\keyword{Value at risk, expected shortfall}
