% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/APPcode.R
\name{runVRPMexample}
\alias{runVRPMexample}
\title{Run R Shiny app}
\usage{
runVRPMexample(example)
}
\arguments{
\item{example}{The name of the application that should be loaded.  \code{example} should be one of
"IntermittentClaudication", "Iris", "Pima" or "xsnz".}
}
\description{
Run a selected R Shiny application to illustrate the working of the VRPM package.
}
\details{
Different applications are possible.  To illustrate the visualization of a logistic regression model, 
an application on the Intermittent Claudication model (see references) can be loaded using 
   \code{example}=	"IntermittentClaudication". Two illustrations for the visualization of support vector machine 
classifiers can be loaded using \code{example}="Iris" and \code{example}="Pima".  To illustrate the possibilities 
for visualizing multinomial logistic regression models, use \code{example}="xsnz".
}
\examples{
\dontrun{
	#### Logistic regression model
	runVRPMexample("IntermittentClaudication")
	#### Multinomial logistic regression model
	runVRPMexample("xsnz")
	#### Support Vector Machine classifier
	runVRPMexample("Iris")
	runVRPMexample("Pima")}

}
\author{
Vanya Van Belle
}
\references{
Van Belle V., Van Calster B., \emph{Visualizing risk prediction models}, PLoS ONE, 10(7):e0132614. doi:10.1371/journal.pone.0132614 (2015).

Van Belle V., Van Calster B., Suykens J.A.K., Van Huffel S. and Lisboa P., \emph{Explaining support vector machines: a color based nomogram}, Internal Report 16-27, ESAT-Stadius, KU Leuven (Leuven, Belgium), 2016

Van Belle V., Van Huffel S., Timmerman D., Froyman W., Bourne T. and Van Calster B., \emph{A color based nomogram for Multinomial Logistic Regression}, Internal Report 16-28, ESAT-Stadius, KU Leuven (Leuven, Belgium), 2016
}

