% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vfp.R
\name{predictMean}
\alias{predictMean}
\title{Finding X-Value for Given Y-Value Using a Bisection-Approach.}
\usage{
predictMean(obj, type = c("vc", "sd", "cv"), model.no = NULL,
  alpha = 0.05, newdata = NULL, tol = 1e-04, ci = TRUE, ...)
}
\arguments{
\item{obj}{(object) of class 'VFP'}

\item{type}{(character) "vc" = variance, "sd" = standard deviation = sqrt(variance), 
"cv" = coefficient of variation}

\item{model.no}{(integer) specifying which model to use in case 'obj' represents multiple
fitted models}

\item{alpha}{(numeric) value specifying the 100x(1-alpha)\% confidence interval for the 
predicted value(s)}

\item{newdata}{(numeric) values representing variability-values on a specific scale ('type')}

\item{tol}{(numeric) tolerance value relative to 'newdata' specifying the stopping criterion
for the bisection algorithm, also used to evaluate equality of lower and upper bounds
in a bisection step for checking whether a boundary can be determined or not}

\item{ci}{(logical) indicates whether confidence intervals for predicted concentrations are
required (TRUE) or not (FALSE), if 'newdata' contains many values the overall computation
time can be minimized to 1/3 leaving out runs of the bisection-algorithm for LCL and UCL}

\item{...}{additional parameter passed forward or used internally}
}
\value{
(data.frame) with variables "Mean" (X-value), "VC", "SD" or "CV" depending on 'type',
			"Diff" the difference to the specified Y-value, "LCL" and "UCL" as limits of the 100x(1-alpha)\% CI.
}
\description{
For given variability-values (Y-axis) on one of three scales (see 'type'), those values on
the X-axis are determined which give fitted values equal to the specification.
}
\details{
This is achieved using a bisection algorithm which converges according to the specified tolerance 'tol'.
In case of 'type="cv"', i.e. if specified Y-values are coefficients of variation, these are interpreted
as percentages (15 = 15\%).
}
\examples{
\donttest{

# perform variance component analyses first
library(VCA)
data(CA19_9)
fits.CA19_9 <- anovaVCA(result~site/day, CA19_9, by="sample")

# extract repeatability
mat.CA19_9 <- getMat.VCA(fits.CA19_9, "error")
res.CA19_9 <- fit.vfp(mat.CA19_9, 1:10)
summary(res.CA19_9)
print(res.CA19_9)

# predict CA19_9-concentration with 5\\\% CV
predictMean(res.CA19_9, newdata=5) 

# this is used in function plot.VFP as well
plot(res.CA19_9, Prediction=list(y=5), type="cv")
plot(res.CA19_9, Prediction=list(y=5), type="cv", 
		xlim=c(0, 80), ylim=c(0, 10))
}
}
\seealso{
\code{\link{fit.vfp}}, \code{\link{predict.VFP}}, \code{\link{plot.VFP}}
}
\author{
Andre Schuetzenmeister \email{andre.schuetzenmeister@roche.com}
}
