% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anova.R
\name{Fsweep}
\alias{Fsweep}
\title{Calling F90-implementation of the SWEEP-Operator}
\usage{
Fsweep(M, asgn, thresh = 1e-10, tol = 1e-10, Ncpu = 1)
}
\arguments{
\item{M}{(matrix) matrix, representing the augmented matrix \eqn{X'X}}

\item{asgn}{(integer) vector, identifying columns in \eqn{M} corresponding to variables, 
respectively, to their coefficients}

\item{thresh}{(numeric) value used to check whether the influence of the a coefficient
to reducing the error sum of squares is small enough to conclude that the
corresponding column in \eqn{X'X} is a linear combination of preceding 
columns}

\item{tol}{(numeric) value used to check numerical equivalence to zero}

\item{Ncpu}{(integer) number of cores to be used for parallel processing
(not yet used)}
}
\value{
(list) with eight elements:\cr
\itemize{
\item{SSQ}{(numeric) vector of ANOVA sum of squares}
\item{LC}{(integer) vector indicating linear dependence of each column}
\item{DF}{(integer) degrees of freedom}
\item{C}{(double precision) Matrix relating the sums of squares to the variances}
\item{Ci}{(double precision) inverse of matrix relating the sums of squares to the variances}
\item{VC}{(double precision)  variance}
\item{SD}{(double precision) standard deviations}
\item{Var}{(double precision) covariance matrix of the estimated variances}
}
}
\description{
Function calls a fast Fortran90-implementation of the SWEEP operator using the
transpose of the original augmented matrix \eqn{X'X} (see \code{\link{getSSQsweep}}).
In the sweeping step, also the C matrix, needed to obtain the variance estimates from 
the sum of squares and the Covariance matrix of the estimates are calculated.
}
\details{
This is an utility-function not intended to be called directly.
}
\author{
Florian Dufey \email{florian.dufey@roche.com}
}
\references{
Goodnight, J.H. (1979), A Tutorial on the SWEEP Operator, The American Statistician, 33:3, 149-158
}

