% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions_BSS_SGL.R
\name{tbss}
\alias{tbss}
\title{block segmentation scheme (BSS).}
\usage{
tbss(
  data,
  method = c("sparse", "group sparse", "fLS")[1],
  group.case = c("columnwise", "rowwise")[1],
  group.index = NULL,
  lambda.1.cv = NULL,
  lambda.2.cv = NULL,
  mu = NULL,
  q = 1,
  max.iteration = 50,
  tol = 10^(-2),
  block.size = NULL,
  blocks = NULL,
  refine = TRUE,
  use.BIC = TRUE,
  an.grid = NULL
)
}
\arguments{
\item{data}{input data matrix, with each column representing the time series component}

\item{method}{method: sparse, group sparse, and fixed low rank plus sparse. Default is sparse}

\item{group.case}{group sparse pattern: column, row.}

\item{group.index}{group index for group sparse case}

\item{lambda.1.cv}{tuning parameter lambda_1 for fused lasso}

\item{lambda.2.cv}{tuning parameter lambda_2 for fused lasso}

\item{mu}{tuning parameter for low rank component, only available when method is set to "fLS"}

\item{q}{the AR order}

\item{max.iteration}{max number of iteration for the fused lasso}

\item{tol}{tolerance for the fused lasso}

\item{block.size}{the block size}

\item{blocks}{the blocks}

\item{refine}{logical; if TRUE, use local refinement in the exhaustive search step. Default is TRUE.}

\item{use.BIC}{use BIC for k-means part}

\item{an.grid}{a vector of an for grid searching}
}
\value{
A list object, which contains the followings
\describe{
  \item{first.selected.points}{a set of selected break point after the first block fused lasso step}
  \item{second.selected.points}{a set of selected break point after the second local screening step}
  \item{final.selected.points}{a set of selected break point after the thrid exhaustive search step}
  \item{final.selected.points.grid}{a list of selected break point after the thrid exhaustive search step for different an values}
  \item{an}{the selected neighborhood size a_n after the grid search}
  \item{final.phi.hat.list}{estimated parameters for each segment}
  \item{timing}{computation time for each step}
}
}
\description{
Perform the block segmentation scheme (BSS) algorithm to detect the structural breaks 
in large scale high-dimensional non-stationary VAR models.
}
\examples{
#### sparse VAR model
nob <- (10^3); #number of time points
p <- 15; # number of time series components
brk <- c(floor(nob/3),floor(2*nob/3),nob+1); # true break points with nob+1 as the last element
m0 <- length(brk) -1; # number of break points
q.t <- 1; # the true AR order
m <- m0+1 #number of segments
try<-simu_var('sparse',nob=nob, k=p, lags=q.t, brk = brk, sp_pattern="off-diagonal")
data <- try$series
data <- as.matrix(data)
#run the bss method
fit <- tbss(data, method = "sparse", q = q.t)
#detected change points:
fit$final.selected.points


######Example for fixed low rank plus sparse structure VAR model
nob <- 300
p <- 15
brk <- c(floor(nob/3), floor(2*nob/3), nob+1)
m <- length(brk)
q.t <- 1
signals <- c(-0.7, 0.7, -0.7)
rank <- c(2, 2, 2)
singular_vals <- c(1, 0.75)
info_ratio <- rep(0.35, 3)
try <- simu_var(method = "fLS", nob = nob, k = p, lags = 1, brk = brk, 
                sigma = as.matrix(diag(p)), signals = signals, 
                rank = rank, singular_vals = singular_vals, info_ratio = info_ratio, 
                sp_pattern = "off-diagonal", spectral_radius = 0.9)
data <- try$series
data <- as.matrix(data)
fit <- tbss(data, method = "fLS", mu = 150)
print(fit$final.selected.points)
print(qr(fit$est.lowrank)$rank)
}
