% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plot_Torta.R
\name{Plot.Torta}
\alias{Plot.Torta}
\title{Cree un gráfico circular/torta/pie dinámico/estático y flexible con dos
diferentes paquetes}
\usage{
Plot.Torta(
  datos,
  valores,
  categoria,
  ano,
  periodo,
  colores,
  titulo = "",
  label = "",
  addPeriodo = FALSE,
  libreria = c("highcharter", "plotly"),
  estilo = NULL,
  estatico = FALSE
)
}
\arguments{
\item{datos}{Un data frame, no un vector numérico.}

\item{valores}{Variable numérica que contiene los valores que desea graficar.}

\item{categoria}{Una variable categórica dentro del data frame ingresado en \code{datos}.}

\item{ano}{Argument deprecated. This Argument still exist but will be removed
in the next version.}

\item{periodo}{Argument deprecated. This Argument still exist but will be removed
in the next version.}

\item{colores}{Cadena de caracteres indicando los colores con los cuales se
deben colorear cada una de las series correspondiente a cada nivel del
argumento \code{categoria}. Si no se introduce algún vector se usará la paleta
\code{rainbow} por defecto.}

\item{titulo}{Cadena de caracteres indicando el título principal del plot.}

\item{label}{Cadena de caracteres indicando la etiqueta a la que hace referencia
el plot.}

\item{addPeriodo}{Argument deprecated. This Argument still exist but will be
removed in the next version.}

\item{libreria}{Cadena de caracteres que indica el paquete con el cual se realizará
el plot. Los valores permitidos son \code{"highcharter"} (\emph{valor predeterminado})
y \code{"plotly"}. Los valores se emparejarán parcialmente.}

\item{estilo}{Lista compuesta por varios parámetros, los cuales van a ser usados
de acuerdo con la librería especificada para graficar la torta y cuyo objetivo
es personalizar pequeños detalles de ésta.
\itemize{
\item \code{LegendTitle}, \code{hc.Tema}, \code{hc.Credits} y \code{ply.Credits}: Igual uso que en
\code{\link[=Plot.Series]{Plot.Series()}}
\item \code{ply.Legend}: Igual uso que en \code{\link[=Plot.Barras]{Plot.Barras()}}
}}

\item{estatico}{Si es \code{FALSE} (\emph{valor predeterminado}) el gráfico a retornar
será dinámico (\emph{dependiendo de la librería seleccionada}), en caso contrario
se retornará un gráfico estático construido con \code{ggplot2}.}
}
\value{
Retorna el diagrama circular (\emph{objeto widget de HTML}) creado. La clase del
objeto retornado será un "htmlwidget" y dependiendo de la librería usada
pertenecerá adicionalmente a la clase "highchart" o "plotly".
}
\description{
Esta función permite mostrar de forma interactiva (\emph{y estática}) una descripción
compacta y general de una variable con sus respectivas categorías. Dicho diagrama
se puede representar usando dos diferentes librerías que son \code{Highcharter} y
\code{Plotly}, las cuales usan internamente \code{JavaScript}.
}
\details{
Al usar el paquete \code{Highcharter} y usar las opciones de descarga, el nombre del
archivo descargado será la concatenación del plot graficado y la categoría usada,
así, por ejemplo, si se graficó el diagrama de pie para la categoría "Sexo" el
nombre será \code{PlotTorta_Sexo.png}.
}
\note{
Los gráficos circulares son una forma muy mala de mostrar información. El ojo
es bueno para juzgar medidas lineales y malo para juzgar áreas relativas. Un
gráfico de barras o un gráfico de puntos es una forma preferible de mostrar
este tipo de datos.
}
\section{Lista de argumentos de estilo}{


Sabemos que puede ser abrumador el número de argumentos dentro del parámetro
\code{estilo}, pero es necesario si queremos ofrecer al usuario la máxima
personalización dentro de cada función usando cualquier librería. Por tal
razón, a continuación, se detalla el listado completo de argumentos, usados
al especificar la librería y en qué función están presentes
(\emph{marcado con una × si lo posee}).\tabular{clcccccccc}{
   \strong{Librería} \tab \strong{estilo$} \tab \code{\link[=Plot.Series]{Plot.Series()}} \tab \code{\link[=Plot.Barras]{Plot.Barras()}} \tab \code{\link[=Plot.Apiladas]{Plot.Apiladas()}} \tab \code{\link[=Plot.Boxplot]{Plot.Boxplot()}} \tab \code{\link[=Plot.Radar]{Plot.Radar()}} \tab \code{\link[=Plot.Treemap]{Plot.Treemap()}} \tab \code{\link[=Plot.Torta]{Plot.Torta()}} \tab \code{\link[=Plot.Drilldown]{Plot.Drilldown()}} \cr
   — \tab \emph{gg.Tema} \tab × \tab × \tab × \tab × \tab  \tab  \tab  \tab  \cr
   l \tab \emph{gg.Texto} \tab × \tab × \tab × \tab × \tab  \tab  \tab  \tab  \cr
   l \tab \emph{gg.Legend} \tab × \tab  \tab × \tab × \tab  \tab  \tab  \tab  \cr
   l \tab \emph{gg.Linea} \tab × \tab  \tab  \tab  \tab  \tab  \tab  \tab  \cr
   l \tab \emph{gg.Punto} \tab × \tab  \tab  \tab  \tab  \tab  \tab  \tab  \cr
   l \tab \emph{gg.Bar} \tab  \tab × \tab × \tab  \tab  \tab  \tab  \tab  \cr
   l \tab \emph{gg.VarWidth} \tab  \tab  \tab  \tab × \tab  \tab  \tab  \tab  \cr
   l \tab \emph{gg.OutShape} \tab  \tab  \tab  \tab × \tab  \tab  \tab  \tab  \cr
   l \tab \emph{gg.JitWidth} \tab  \tab  \tab  \tab × \tab  \tab  \tab  \tab  \cr
   l \tab \emph{gg.JitSize} \tab  \tab  \tab  \tab × \tab  \tab  \tab  \tab  \cr
   l \tab \emph{gg.Range} \tab  \tab  \tab  \tab  \tab × \tab  \tab  \tab  \cr
   \strong{ggplot2} \tab \emph{gg.plty} \tab  \tab  \tab  \tab  \tab × \tab  \tab  \tab  \cr
   l \tab \emph{gg.plwd} \tab  \tab  \tab  \tab  \tab × \tab  \tab  \tab  \cr
   l \tab \emph{gg.cglwd} \tab  \tab  \tab  \tab  \tab × \tab  \tab  \tab  \cr
   l \tab \emph{gg.cglcol} \tab  \tab  \tab  \tab  \tab × \tab  \tab  \tab  \cr
   l \tab \emph{gg.fontsize.title} \tab  \tab  \tab  \tab  \tab  \tab × \tab  \tab  \cr
   l \tab \emph{gg.fontsize.labels} \tab  \tab  \tab  \tab  \tab  \tab × \tab  \tab  \cr
   l \tab \emph{gg.fontcolor.labels} \tab  \tab  \tab  \tab  \tab  \tab × \tab  \tab  \cr
   l \tab \emph{gg.border.lwds} \tab  \tab  \tab  \tab  \tab  \tab × \tab  \tab  \cr
   l \tab \emph{gg.border.col} \tab  \tab  \tab  \tab  \tab  \tab × \tab  \tab  \cr
   l \tab \emph{gg.lowerbound.cex.labels} \tab  \tab  \tab  \tab  \tab  \tab × \tab  \tab  \cr
   l \tab \emph{gg.force.print.labels} \tab  \tab  \tab  \tab  \tab  \tab × \tab  \tab  \cr
   — \tab \emph{gg.overlap.labels} \tab  \tab  \tab  \tab  \tab  \tab × \tab  \tab  \cr
   » \tab \emph{hc.Tema} \tab × \tab × \tab × \tab × \tab  \tab × \tab × \tab × \cr
   l \tab \emph{hc.Credits} \tab × \tab × \tab × \tab × \tab  \tab × \tab × \tab × \cr
   \strong{highcharter} \tab \emph{hc.BoxInfo} \tab × \tab  \tab  \tab  \tab  \tab  \tab  \tab  \cr
   l \tab \emph{hc.Slider} \tab × \tab  \tab  \tab  \tab  \tab  \tab  \tab  \cr
   » \tab \emph{hc.borderRadius} \tab  \tab  \tab  \tab  \tab  \tab × \tab  \tab  \cr
   • \tab \emph{ply.Credits} \tab × \tab × \tab × \tab × \tab × \tab × \tab × \tab  \cr
   ° \tab \emph{ply.Legend} \tab  \tab × \tab  \tab  \tab  \tab  \tab × \tab  \cr
   ° \tab \emph{ply.LegendPosition} \tab × \tab  \tab × \tab × \tab × \tab  \tab  \tab  \cr
   \strong{plotly} \tab \emph{ply.Interaction} \tab × \tab  \tab  \tab × \tab  \tab  \tab  \tab  \cr
   ° \tab \emph{ply.Relleno} \tab  \tab  \tab  \tab  \tab × \tab  \tab  \tab  \cr
   ° \tab \emph{ply.Opacidad} \tab  \tab  \tab  \tab  \tab × \tab × \tab  \tab  \cr
   • \tab \emph{ply.LegendTitle} \tab  \tab  \tab  \tab  \tab × \tab  \tab  \tab  \cr
   \strong{dygraphs} \tab \emph{dyg.LegendWidth} \tab × \tab  \tab  \tab  \tab  \tab  \tab  \tab  \cr
   » \tab \emph{dyg.Resaltar} \tab × \tab  \tab  \tab  \tab  \tab  \tab  \tab  \cr
   — \tab \emph{e.Tema} \tab  \tab  \tab  \tab  \tab × \tab  \tab  \tab  \cr
   l \tab \emph{e.Credits} \tab  \tab  \tab  \tab  \tab × \tab  \tab  \tab  \cr
   \strong{echarts4r} \tab \emph{e.Forma} \tab  \tab  \tab  \tab  \tab × \tab  \tab  \tab  \cr
   l \tab \emph{e.LegType} \tab  \tab  \tab  \tab  \tab × \tab  \tab  \tab  \cr
   — \tab \emph{e.LegLoc} \tab  \tab  \tab  \tab  \tab × \tab  \tab  \tab  \cr
}
}

\examples{
\dontshow{if (all(require("tibble"), require("dplyr"))) withAutoprint(\{ # examplesIf}
# Ejemplo generalizado (sin uso de un consolidado como input)
# library("tibble"); library("dplyr")
set.seed(42)
Blood <- tibble(
  Group = sample(c("O", "A", "B", "AB"), size = 200, prob = c(0.5, 0.3, 0.16, 0.4), replace = TRUE),
  Prevalence = round(runif(200)*100)
)
Plot.Torta(
  datos     = Blood     ,
  valores   = Prevalence,
  categoria = Group     ,
  colores   = c("#FF553D", "#A5FF67", "#40D2FF", "#FFDB5C"),
  label     = "No. of Prevalence"
)
Plot.Torta(
  datos     = Blood     ,
  valores   = Prevalence,
  categoria = Group     ,
  colores   = c("#FF553D", "#A5FF67", "#40D2FF", "#FFDB5C"),
  titulo    = "DISTRIBUTION OF BLOOD GROUPS",
  estatico  = TRUE,
  estilo    = list(gg.Tema = 6)
)
Plot.Torta(
  datos     = Blood     ,
  valores   = Prevalence,
  categoria = Group     ,
  colores   = c("#FF553D", "#A5FF67", "#40D2FF", "#FFDB5C"),
  titulo    = "DISTRIBUTION OF BLOOD GROUPS",
  estatico  = TRUE,
  estilo = list(
    gg.Tema  = 7, gg.Donut = TRUE, gg.Percent = FALSE,
    gg.Texto = list(
      subtitle = "Synthetic or fake data that resembles real-world data",
      caption  = "* Data Simulation",
      tag      = "\u00ae"
    )
  )
)
\dontshow{\}) # examplesIf}
\dontshow{if (require("dplyr")) withAutoprint(\{ # examplesIf}
# ---------------------------------------------------------------------------
col <- c("#F15A24", "#8CC63F")
Msj <- "Distribuci\u00f3n de estudiantes graduados en el primer periodo acad\u00e9mico del 2021."
Txt <- "DISTRIBUCI\u00d3N DE GRADUADOS POR MODALIDAD DE FORMACI\u00d3N"
Plot.Torta(
  datos     = ejConsolidadoGrad |> filter(YEAR==2021, SEMESTRE==1),
  categoria = "TIPO_NIVEL",
  colores   = col,
  titulo    = paste(Txt, "(Periodo 2021-1)"),
  label     = "N\u00famero de Graduados",
  libreria  = "highcharter",
  estilo    = list(
    LegendTitle = "\u00c9sta es una descripci\u00f3n para la leyenda:",
    hc.Tema = 7, hc.Credits = Msj
  )
)
# ---------------------------------------------------------------------------
Msj <- "Distribuci\u00f3n hist\u00f3rica de estudiantes graduados (desde el 2009-I al 2021-I)."
Plot.Torta(
  datos     = ejConsolidadoGrad,
  categoria = "TIPO_NIVEL",
  colores   = col,
  titulo    = gsub("DOS POR", "DOS\nPOR", Txt),
  libreria  = "plotly",
  estilo    = list(
    ply.Legend = "inside", ply.Credits = list(
      x = 0.8, y = 1.1, text = paste0("<b>", Msj, "</b>")
    )
  )
)
\dontshow{\}) # examplesIf}
}
