% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FourierBasis.R
\name{FourierBasis}
\alias{FourierBasis}
\title{Fourier basis functions}
\usage{
FourierBasis(a, m, x)
}
\arguments{
\item{a}{Sine or cosine; \eqn{a=0} gives cosine and \eqn{a=1} gives sine.}

\item{m}{Vector of frequencies \eqn{m}.}

\item{x}{Vector of locations \eqn{x}.}
}
\value{
Returns the values of \eqn{\sqrt{2} \cos(2\pi m x)}.
}
\description{
Computes the values of the one-dimensional Fourier basis functions at a vector of locations \eqn{x}
and with a vector of frequencies \eqn{m}. The scaling factor of \eqn{2\pi} is included, so that
the function returns, e.g., \eqn{\sqrt{2} \cos(2\pi m x)}.
}
\examples{
e=FourierBasis(1,1:100,0.01); plot(0.01*(1:100),e,type="l")
e=FourierBasis(0,1,0.01*(1:100)); plot(0.01*(1:100),e,type="l")
FourierBasis(1,1:3,0.1*(1:10))

}
\references{
\insertRef{BKS2020}{USP}
}
