% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/innerLoop.R
\name{innerLoop}
\alias{innerLoop}
\title{UPMASK inner loop}
\usage{
innerLoop(ocdata_full, ocdata, classAlgol="kmeans", autoThresholdLevel=3, 
autoThreshold=TRUE, iiter=0, plotIter=FALSE, verbosity=1, starsPerClust_kmeans=50, 
nstarts_kmeans=50, runId=0, autoCalibrated=FALSE, stopIfEmpty=FALSE, 
positionDataIndexes=c(1,2), smartTableDB, nDimsToKeep=4, dimRed="PCA", scale=TRUE)
}
\arguments{
\item{ocdata_full}{a data frame with the data to perform the analysis}

\item{ocdata}{a data frame with the data to consider in the PCA step}

\item{classAlgol}{a string indicating the type of clustering algorithm to consider. Only k-means is implemented at this moment (defaults to kmeans)}

\item{autoThresholdLevel}{an integer indicating the level for thresholding of the spatial distribution}

\item{autoThreshold}{a boolean indicating if autoThresolding should be adopted (defaults to TRUE)}

\item{iiter}{and integer indicating the number of the iteration (passed by the \code{outerLoop})}

\item{plotIter}{a boolean indicating if the user wants to see iteration plots (defaults to FALSE)}

\item{verbosity}{a flag indicating the verbosity level: it can be 0 (no screen output at all), 1 (minimum), >=2 (all)}

\item{starsPerClust_kmeans}{an integer with the average number of stars per k-means cluster}

\item{nstarts_kmeans}{an integer the amount of random re-initializations of the k-means clustering method (usually it is not necessary to modify this)}

\item{runId}{an integer greater than zero indicating the run Id (passed by the \code{outerLoop})}

\item{autoCalibrated}{a boolean indicating if the number of random field realizations for the clustering check in the position space should be autocalibrated (experimental code, defaults to FALSE).}

\item{stopIfEmpty}{a boolean indicating if the code should completely stop if no spatial clustering is detected (defaults to FALSE)}

\item{positionDataIndexes}{an array of integers indicating the columns of the data frame containing the spatial position measurements}

\item{smartTableDB}{a database connection to the smart look-up table}

\item{nDimsToKeep}{an integer with the number of dimensions to consider (defaults to 4)}

\item{dimRed}{a string with the dimensionality reduction method to use (defaults to PCA. The only other options are LaplacianEigenmaps or None)}

\item{scale}{a boolean indicating if the data should be scaled and centered}
}
\value{
A data frame with objects considered as members at this iteration.
}
\description{
\code{innerLoop} executes the UPMASK method's inner loop and returns 
the stars which were considered as cluster member stars.

The \code{innerLoop} perform the PCA, runs the clustering algorithm and check for 
overdensities in the spatial distribution for the clustered stars in the PC space using
a 2d kernel density estimation.
}
\examples{
\dontrun{
# Perform a one run of the innerLoop using a simulated open cluster with 
# spatial and photometric data 
# Load the data into a data frame
fileName <- "oc_12_500_1000_1.0_p019_0880_1_25km_120nR_withcolors.dat"
inputFileName <- system.file("extdata", fileName, package="UPMASK")
ocData <- read.table(inputFileName, header=TRUE)
ocData <- data.frame(ocData, id=(1:length(ocData[,1]))) # create an id

# Prepare the data to run the inner loop
posIdx <- c(1,2)
photIdx <- c(3,5,7,9,11,19,21,23,25,27)

# Create the look up table
library(RSQLite)
stcon <- create_smartTable()

# Run the inner loop 
innerLoopRes <- innerLoop(ocData, ocData[,photIdx], autoThresholdLevel=1, verbosity=2,
                          starsPerClust_kmeans=25, positionDataIndexes=posIdx, 
                          smartTableDB=stcon)

# Clean the environment
rm(list=c("inputFileName", "ocData", "posIdx", "photIdx", "innerLoopRes", 
   "fileName"))
dbDisconnect(stcon)
} 
 
}
\references{
\href{http://dx.doi.org/10.1051/0004-6361/201321143}{Krone-Martins, A. & Moitinho, A., A&A, v.561, p.A57, 2014}
}
\author{
Alberto Krone-Martins, Andre Moitinho
}
\keyword{cluster,}
\keyword{methods,}
\keyword{multivariate,}
\keyword{nonparametric}
