% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.UPCM.R
\name{plot.UPCM}
\alias{plot.UPCM}
\title{Plot function for UPCM}
\usage{
\method{plot}{UPCM}(x, sig = 0.05, KIfactor = 0.9, xlim, ylim, \dots)
}
\arguments{
\item{x}{\code{UPCM} object}

\item{sig}{Significance level for confidence intervals, default is \code{sig = 0.05}.}

\item{KIfactor}{Parameter to regulate the shape of the resulting star.}

\item{xlim}{See \code{xlim} in \code{\link{plot.default}}.}

\item{ylim}{See \code{ylim} in \code{\link{plot.default}}.}

\item{...}{Further plot arguments.}
}
\value{
No return value, called for side effects
}
\description{
Plot function for a \code{UPCM} or a \code{UGPCM} object. Plots show coefficient estimates together with
confidence intervals displayed as star plots.
}
\examples{
\donttest{
data(tenseness)

Y <- data.matrix(tenseness[,1:4])
X <- model.matrix(~ Gender + Age, data = tenseness)[,-1]

m_upcm <- UPCM(Y = Y, X = X, cores = 2, GPCM = FALSE)
m_upcm
plot(m_upcm)
}
}
\references{
Tutz, Gerhard and Schauberger, Gunther (2020): Uncertainty in Latent Trait Models, 
\emph{Applied Psychological Measurement}, \url{https://journals.sagepub.com/doi/abs/10.1177/0146621620920932?journalCode=apma}
}
\seealso{
\code{\link{UPCM}}
}
\author{
Gunther Schauberger\cr \email{gunther.schauberger@tum.de}\cr
\url{https://www.sg.tum.de/epidemiologie/team/schauberger/}
}
