% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objective_fn.R
\name{objective_fn_numint}
\alias{objective_fn_numint}
\title{Compute Unlinked Monotone Regression objective function numerically}
\usage{
objective_fn_numint(
  mm,
  ww_m = NULL,
  yy,
  ww_y = NULL,
  Phi,
  subdivisions = 1000L
)
}
\arguments{
\item{mm}{Current  (unsorted) estimate/iterate  at  which  to  compute
gradient.  (Length  is <=  than the  number of  X observations  in the
problem).}

\item{ww_m}{Weights (nonnegative,  sum to  1) corresponding to  mm.  Same
length as mm.}

\item{yy}{Y   (response)  observation   vector  (numeric   vector).
Alternatively,  yy  may be  an  ecdf,  i.e.  ecdf(yy)  or  getEcdf(yy,
weights).}

\item{ww_y}{Weights (nonnegative,  sum to  1) corresponding to  yy.  Same
length as yy.  Default is just  1/length(yy) for each value.  If yy is
non-numeric i.e. yy is an ecdf() then ww_y is ignored.}

\item{Phi}{This is the error (cumulative) distribution function, a  function object (Balabdaoui, Doss, Durot (2020+).  Function accepting vector or matrix arguments.}

\item{subdivisions}{Passed argument to integrate().}
}
\description{
Compute Unlinked Monotone Regression objective function numerically
}
\details{
See paper for derivations.
}
