% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All.R
\name{BivarSim}
\alias{BivarSim}
\title{Bivariate extremes simulation}
\usage{
BivarSim(
  x,
  y,
  thresh = 0.95,
  div = NULL,
  TimeDiv = NULL,
  n = 1000,
  EW = 1,
  ylab = "y",
  xlab = "x"
)
}
\arguments{
\item{x}{The x variable as a data.frame, with date or POSIXct in the first column and numeric vector in the second}

\item{y}{The y variable as a data.frame, with date or POSIXct in the first column and numeric vector in the second}

\item{thresh}{Numeric. The threshold for extracting the POT. The default is 0.95.}

\item{div}{Numeric value (percentile). A lower value to de-cluster the POT. Default is the mean.}

\item{TimeDiv}{Numeric. An additional time based de-clustering option. At the scale of the data time-step. See POTextract for more details}

\item{n}{Numeric. The sample size of the bivariate simulation.}

\item{EW}{Numeric. The event window (based on timestep of x and y). The peak of y is extracted from the y values EW prior to and after the x peak.}

\item{ylab}{Character. The y label for the plot}

\item{xlab}{Character. The x label for the plot}
}
\value{
A list with four elements. The first element is a data.frame of the concurrent events above the threshold.
The second and third are the extracted POT data for x and y. The fourth is a data.frame of simulated results.
The simulated results has six columns: x, y, RP of x, RP of y, Weibull joint annual exceedance RP, and Gringorten joint annual exceedance RP
}
\description{
Simulates bivariate extremes using a threshold Gaussian copula
}
\details{
The simulation process is as follows. Extract POT data for the x variable and find concurrent peaks for the y variable
(over a user defined event window). Simulate the x and y concurrent peaks over the threshold assuming a bivariate normal distribution.
Having estimated Generalised Pareto distribution parameters for both x and y, calculate GPD quantiles from the bivariate normal simulated cumulative probabilities.
The joint exceedance return periods are calculated by ranking x and y (descending), then summing the ranks and ranking those (ascending).
The reciprocal of the Weibull formula (rank/(n+1)) and Gringorten are then applied ((Rank-0.44)/(n+0.12)) - and divided by the number of concurrent peaks above the threshold per year.
It's recommended that the variable with the fewest peaks per year be used as x.
Return periods for x and y are determined by the GPD including the peaks per year.
Therefore the variable with fewer peaks per year will likely have shorter return periods on average for a given simulation.
x and y don't have to be the same length, the function will truncate to a concurrent timeframe based on the Date or POSIXct column.
}
\examples{
# Simulate the bivariate extremes for the daily flow on the Thames at Kingston
#and on the Hogsmill at Kingston.
SimExample <- BivarSim(ThamesPQ[,c(1,3)], ThamesPQ[,c(1,4)],
thresh = 0.9, n = 10000)
#Subset the simulated data so that the Hogsmill (y variable) is approximately
#at the 50-year return level
subset(SimExample$Simulation, yRP > 48 & yRP < 52)
#Subset the simulated data so that the joint annual exceedance return period
#is approximately 50
subset(SimExample$Simulation, WeibullRP > 48 & WeibullRP < 52)
}
\author{
Anthony Hammond
}
