% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IMU_TwoRegressionProcessing_MasterFunction.R
\name{hibbing18_twoReg_process}
\alias{hibbing18_twoReg_process}
\title{Process GT9X Files with Hibbing Two-Regression Algorithms}
\usage{
hibbing18_twoReg_process(RAW, IMU = NULL, Wear_Location = c("Hip",
  "Left Wrist", "Right Wrist", "Left Ankle", "Right Ankle"), PID,
  Algorithm = 1, verbose = FALSE, IMU_ignore_A1 = TRUE)
}
\arguments{
\item{RAW}{A character scalar giving path to primary accelerometer data file}

\item{IMU}{A character scalar giving path to IMU data file}

\item{Wear_Location}{A character scalar indicating the device's attachment site}

\item{PID}{A character scalar giving the participant identification}

\item{Algorithm}{A numeric vector giving the algorithm(s) to apply to the data from the primary accelerometer and (if applicable) IMU}

\item{verbose}{A logical scalar: print progress updates?}

\item{IMU_ignore_A1}{A logical scalar. If Algorithm = 1, should IMU files be ignored?}
}
\value{
A data frame giving the data and predictions
}
\description{
Process GT9X primary accelerometer and (if applicable) IMU files using one or more of the algorithms from \href{https://www.ncbi.nlm.nih.gov/pubmed/29271847}{Hibbing et al. (2018, \emph{Med Sci Sports Exerc})}.
}
\examples{
\dontrun{
raw_file <-
    system.file("extdata",
        "TestID_LeftWrist_RAW.csv",
        package = "TwoRegression")

imu_file <-
    system.file("extdata",
        "TestID_LeftWrist_IMU.csv",
        package = "TwoRegression")

wear <- "Left Wrist"
id <- "Test"
alg <- 1:2

hibbing18_twoReg_process(raw_file, imu_file, wear, id, alg)
}
}
