% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sensor_Functions.R
\name{classify_magnetometer}
\alias{classify_magnetometer}
\title{Convert magnetometer signal to cardinal direction}
\usage{
classify_magnetometer(x = "Magnetometer X", y = "Magnetometer Y",
  z = "Magnetometer Z", orientation = "vertical")
}
\arguments{
\item{x}{x-axis magnetometer data}

\item{y}{y-axis magnetometer data}

\item{z}{z-axis magnetometer data}

\item{orientation}{the conversion scheme to use, from c("vertical",
"horizontal")}
}
\description{
Convert magnetometer signal to cardinal direction
}
\examples{
\dontrun{
data(imu_to_collapse)

X <- mean(imu$Magnetometer.X)
Y <- mean(imu$Magnetometer.Y)
Z <- mean(imu$Magnetometer.Z)

TwoRegression:::classify_magnetometer(X, Y, Z)
}

}
\seealso{
\url{http://s3.amazonaws.com/actigraphcorp.com/wp-content/uploads/2017/11/26205750/ActiGraph_IMU_White_Paper.pdf}
}
\keyword{internal}
