% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tmvt.R
\name{pmvt}
\alias{pmvt}
\title{Distribution function of the multivariate Student distribution for arbitrary limits}
\usage{
pmvt(mu, sigma, df, lb = -Inf, ub = Inf, type = c("mc", "qmc"),
  log = FALSE, B = 10000)
}
\arguments{
\item{mu}{vector of location parameters}

\item{sigma}{scale matrix}

\item{df}{degrees of freedom}

\item{lb}{vector of lower truncation limits}

\item{ub}{vector of upper truncation limits}

\item{type}{string, either of \code{mc} or \code{qmc} for Monte Carlo and quasi Monte Carlo, respectively}

\item{log}{logical; if \code{TRUE}, probabilites and density are given on the log scale.}

\item{B}{number of replications for the (quasi)-Monte Carlo scheme}
}
\description{
This function computes the distribution function of a multivariate normal distribution vector for an arbitrary rectangular region [\code{lb}, \code{ub}].
\code{pmvt} computes an estimate and the value is returned along with a relative error and a deterministic upper bound of the distribution function of the multivariate normal distribution.
Infinite values for vectors \eqn{u} and \eqn{l} are accepted. The Monte Carlo method uses sample size \eqn{n}: the larger the sample size, the smaller the relative error of the estimator.
}
\examples{
d <- 15; nu <- 30;
l <- rep(2, d); u <- rep(Inf, d);
sigma <- 0.5 * matrix(1, d, d) + 0.5 * diag(1, d);
est <- pmvt(lb = l, ub = u, sigma = sigma, df = nu)
# mvtnorm::pmvt(lower = l, upper = u, df = nu, sigma = sigma)
\dontrun{
d <- 5
sigma <- solve(0.5 * diag(d) + matrix(0.5, d, d))
# mvtnorm::pmvt(lower = rep(-1,d), upper = rep(Inf, d), df = 10, sigma = sigma)[1]
pmvt(lb = rep(-1, d), ub = rep(Inf, d), sigma = sigma, df = 10)
}
}
\references{
Z. I. Botev and P. L'Ecuyer (2015), Efficient probability estimation
and simulation of the truncated multivariate Student-t distribution,
Proceedings of the 2015 Winter Simulation Conference, pp. 380-391
}
\author{
\code{Matlab} code by Zdravko I. Botev, \code{R} port by Leo Belzile
}
