% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.recruitment.R
\name{plot.recruitment}
\alias{plot.recruitment}
\title{Plot of recruitment patterns}
\usage{
\method{plot}{recruitment}(
  x,
  percent = TRUE,
  col = "darkgreen",
  xtitle = "default",
  ytitle = "default",
  ...
)
}
\arguments{
\item{x}{list of the class \code{"recruitment"}}

\item{percent}{logical; should number of recruits be relative (percentage)?}

\item{col}{colour of bars (default is "darkgreen")}

\item{xtitle}{title of x axis (default "rel. months" or no title, respectively)}

\item{ytitle}{title of y axis (default "# Recruits" or "Recruits [\%]", respectively)}

\item{...}{standard parameters of \code{\link{barplot}}}
}
\description{
This function plots the recruitment patterns from the
     \link{recruitment} model.
}
\examples{
dat <- list(midLengths = seq(2,98,4),
               catch = c(0.6,17.6,93,83.2,12.6,0.3,0,0,0,1,17.1,51.4,
               26.1,2.2,0.2,4.5,21.6,17.6,3.7,8.7,10.6,6.3,5.6,2.9,0.8),
               Linf = 100,
               K = 0.5)
output <- recruitment(param = dat, tsample = 0.25)
plot(output, percent = FALSE)

}
\references{
Sparre, P., Venema, S.C., 1998. Introduction to tropical fish stock assessment.
Part 1. Manual. FAO Fisheries Technical Paper, (306.1, Rev. 2). 407 p.
}
