% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitFarringtonManning.R
\name{fitFarringtonManning}
\alias{fitFarringtonManning}
\title{Farrington-Manning test for rate difference}
\usage{
fitFarringtonManning(endpoint, placebo, data, alternative, ..., delta = 0)
}
\arguments{
\item{endpoint}{Character. Name of the endpoint in \code{data}.}

\item{placebo}{Character. String indicating the placebo in \code{data$arm}.}

\item{data}{Data frame. Usually it is a locked data set.}

\item{alternative}{a character string specifying the alternative hypothesis,
must be one of \code{"greater"} or \code{"less"}, i.e.,
one-sided test is enforced. No default value.
\code{"greater"} means superiority of treatment over placebo is established
by rate difference greater than `delta`.}

\item{...}{Subset conditions compatible with \code{dplyr::filter}.
\code{glm} will be fitted on this subset only. This argument can be useful
to create a subset of data for analysis when a trial consists of more
than two arms. By default, it is not specified,
all data will be used to fit the model. More than one condition can be
specified in \code{...}, e.g.,
\code{fitFarringtonManning('remission', 'pbo', data, delta, arm \%in\% c('pbo', 'low dose'), cfb > 0.5)},
which is equivalent to:
\code{fitFarringtonManning('remission', 'pbo', data, delta, arm \%in\% c('pbo', 'low dose') & cfb > 0.5)}.
Note that if more than one treatment arm are present in the data after
applying filter in \code{...}, models are fitted for placebo verse
each of the treatment arms.}

\item{delta}{the rate difference between a treatment arm and placebo under
the null. 0 by default.}
}
\value{
a data frame with three columns:
\describe{
\item{\code{arm}}{name of the treatment arm. }
\item{\code{placebo}}{name of the placebo arm. }
\item{\code{estimate}}{estimate of rate difference. }
\item{\code{p}}{one-sided p-value for log odds ratio (treated vs placebo). }
\item{\code{info}}{sample size in the subset with \code{NA} being removed. }
\item{\code{z}}{the z statistics of log odds ratio (treated vs placebo). }
}
}
\description{
Test rate difference by comparing it to a pre-specified value using the
Farrington-Manning test.

Refer to \href{https://zhangh12.github.io/TrialSimulator/articles/wrappers.html}{this vignette}
for more information and examples.
}
\references{
Farrington, Conor P., and Godfrey Manning. "Test statistics and sample size formulae for comparative binomial trials with null hypothesis of non-zero risk difference or non-unity relative risk." Statistics in medicine 9.12 (1990): 1447-1454.
}
