% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_utils.R
\name{weight_func}
\alias{weight_func}
\title{Weight Calculation Function}
\usage{
weight_func(
  sw_data,
  switch_n_cov = NA,
  switch_d_cov = NA,
  eligible_wts_0 = NA,
  eligible_wts_1 = NA,
  cense = NA,
  pool_cense = FALSE,
  cense_d_cov = NA,
  cense_n_cov = NA,
  save_weight_models = FALSE,
  save_dir,
  quiet = FALSE,
  glm_function = "glm",
  ...
)
}
\arguments{
\item{sw_data}{A data.table}

\item{switch_n_cov}{A RHS formula for modelling probability of switching treatment. Used in the numerator of weight
calculation. May use \code{time_on_regime} to include treatment duration.}

\item{switch_d_cov}{A RHS formula for modelling probability of switching treatment. Used in the denominator of weight
calculation. May use \code{time_on_regime} to include treatment duration.}

\item{eligible_wts_0}{Eligibility criteria used in weights for model condition Am1 = 0}

\item{eligible_wts_1}{Eligibility criteria used in weights for model condition Am1 = 1}

\item{cense}{Censoring variable}

\item{pool_cense}{Fit pooled or separate censoring models for those treated and
those untreated at the immediately previous visit.
(default is \code{FALSE}, separate numerator and denominator models for treatment groups)}

\item{cense_d_cov}{A RHS formula for modelling probability of being censored. Used in the numerator of weight
calculation.}

\item{cense_n_cov}{A RHS formula for modelling probability of being censored. Used in the denominator of weight
calculation.}

\item{save_weight_models}{Save weight models objects in \code{data_dir}.}

\item{save_dir}{Directory to save tidy weight model summaries in as 'weight_models.rda'}

\item{quiet}{Don't print progress messages.}

\item{glm_function}{Which glm function to use for the final model from \code{stats} or \code{parglm} packages}

\item{...}{Additional arguments passed to \code{glm_function}. This may be used to specify initial parameter estimates
or arguments to \code{control}. See \link[stats:glm]{stats::glm}, \link[parglm:parglm]{parglm::parglm} and \code{\link[parglm:parglm.control]{parglm::parglm.control()}} for more information.}
}
\description{
This function performs the calculation for weight of the data
}
\keyword{internal}
