% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UtilityFunctions.R
\name{daylength}
\alias{daylength}
\title{Day Length}
\usage{
daylength(lat, doy)
}
\arguments{
\item{lat}{\code{numeric} latitude (decimal degrees).}

\item{doy}{\code{numeric} day of year (1-366). This can be obtained from standard date via \code{\link{day_of_year}}.}
}
\value{
\code{numeric} day length (hours).
}
\description{
The function calculates daylength in hours as a function of latitude and day of year. Uses the CMB model \insertCite{Campbell1998}{TrenchR}.
}
\examples{
  daylength(lat = 47.61, 
            doy = 112)

}
\references{
\insertAllCited{}
}
\seealso{
Other utility functions: 
\code{\link{airpressure_from_elev}()},
\code{\link{azimuth_angle}()},
\code{\link{day_of_year}()},
\code{\link{dec_angle}()},
\code{\link{solar_noon}()},
\code{\link{temperature conversions}},
\code{\link{zenith_angle}()}
}
\concept{utility functions}
