% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_rearrangement.R
\name{CollapseNode}
\alias{CollapseNode}
\alias{CollapseNode.phylo}
\alias{CollapseEdge}
\title{Collapse nodes on a phylogenetic tree}
\usage{
CollapseNode(tree, nodes)

\method{CollapseNode}{phylo}(tree, nodes)

CollapseEdge(tree, edges)
}
\arguments{
\item{tree}{A tree of class \code{\link[ape:read.tree]{phylo}}.}

\item{nodes, edges}{Integer vector specifying the nodes or edges in the tree
to be dropped.
(Use \code{\link[ape]{nodelabels}()} or
\code{\link[ape:nodelabels]{edgelabels}()}
to view numbers on a plotted tree.)}
}
\value{
\code{CollapseNode()} and \code{CollapseEdge()} return a tree of class \code{phylo},
corresponding to \code{tree} with the specified nodes or edges collapsed.
The length of each dropped edge will (naively) be added to each descendant
edge.
}
\description{
Collapses specified nodes or edges on a phylogenetic tree, resulting in
polytomies.
}
\examples{
oldPar <- par(mfrow = c(3, 1), mar = rep(0.5, 4))

tree <- as.phylo(898, 7)
tree$edge.length <- 11:22
plot(tree)
nodelabels()
edgelabels()
edgelabels(round(tree$edge.length, 2),
           cex = 0.6, frame = "n", adj = c(1, -1))

# Collapse by node number
newTree <- CollapseNode(tree, c(12, 13))
plot(newTree)
nodelabels()
edgelabels(round(newTree$edge.length, 2),
           cex = 0.6, frame = "n", adj = c(1, -1))

# Collapse by edge number
newTree <- CollapseEdge(tree, c(2, 4))
plot(newTree)

par(oldPar)

}
\seealso{
Other tree manipulation: 
\code{\link{AddTip}()},
\code{\link{ConsensusWithout}()},
\code{\link{DropTip}()},
\code{\link{EnforceOutgroup}()},
\code{\link{ImposeConstraint}()},
\code{\link{KeptPaths}()},
\code{\link{KeptVerts}()},
\code{\link{LeafLabelInterchange}()},
\code{\link{MakeTreeBinary}()},
\code{\link{RenumberTips}()},
\code{\link{RenumberTree}()},
\code{\link{Renumber}()},
\code{\link{RootTree}()},
\code{\link{SortTree}()},
\code{\link{Subtree}()},
\code{\link{TrivialTree}}
}
\author{
Martin R. Smith
}
\concept{tree manipulation}
