mytree.asymmetric.age <-
function (age, distributionspname, distributionspparameters, distributionextname, distributionextparameters, complete=TRUE, labellivingsp="sp.", labelextinctsp="ext.")
{ 
	stop <- FALSE
	mytree <-list(edge=NULL, tip.label=NULL, edge.length=NULL, Nnode=NULL,  root.edge=NULL, age=NULL)
	class(mytree) <- "phylo"
	edge <- matrix(c(-1,-2), ncol=2)
	leaves <- NULL
	realleaves <- NULL
	extinct <- NULL
	tip.label <- NULL
	udistributionspparameters <- capture.output (cat(distributionspparameters, sep=","))
	udistributionextparameters <- capture.output (cat(distributionextparameters, sep=","))
	rnumbsp <- parse(text=paste(distributionspname, "(1,", udistributionspparameters,")"))
	rnumbext <- parse(text=paste(distributionextname, "(1,", udistributionextparameters,")"))
trajectory  <- function (trace){
	#trace should indicate the edge number that is to be followed until the origin
	trajectory  <- NULL
	while ( length( which(edge[,2] == trace)) ){
		atual  <- which(edge[,2] == trace)
		trajectory  <- c(edge.length[atual], trajectory)
		trace  <- edge[atual,1]
	}
	return(trajectory)
}  
# tracing back the time for one species until the "until"
trajectoryuntil  <- function (trace, until){
	#trace should indicate the edge number that is to be followed until the "until"
	atual <- trace
	trajectoryuntil  <- NULL
	while ( trace != until ){
		atual  <- which(edge[,2] == trace)
		trajectoryuntil  <- c(edge.length[atual], trajectoryuntil)
		trace  <- edge[atual,1]
	}
	return(trajectoryuntil)
}
# initial if in case the (-1,-2) edge get extinct or bigger than age
spt <- eval(rnumbsp)
#to remove NaN warnings messages in case of zero inside the distribution parameters
{
if (distributionextparameters[1] == 0)
{
	extt <- suppressWarnings(eval(rnumbext))
}
else
{
	extt <- eval(rnumbext)
}
}
{
if (is.nan(extt))
{
	extt <- age + 0.1 # we add 0.1 to age so that an extinction event will never happen
}
}
{
if (spt <= extt)
{
	status <- "sp" #occurred an speciation
	edge.length <- spt
	leaves <- -2
}
else
{
	status <- "ext" #occurred an extinction
	edge.length <- extt
	extinct <- -2
	stop <- TRUE
}
}

{
if (min(spt,extt) >= age)
{
	edge.length <- age
	stop <- TRUE
	{
	if (status == "sp")
	{
		realleaves <- leaves
		leaves <- NULL					
	}
	else
	{
		realleaves <- extinct			
		extinct <- NULL
	}
	}
}
}
# in here are stored all ages for death of species and their descendent and status
godbook <- list(from=-1,to=-2,destiny=extt, status=status)
# for the while (increase of the tree)
while (stop == FALSE) 
{
	species <- leaves[1]
	nextsp <- min(edge[,2])
	#for the mother prolong
	i <- 1
	edge <- rbind( edge, c(species, (nextsp - i)))
	motherage <- sum(    trajectoryuntil(   godbook$to[which(godbook$to == species)]  ,    godbook$from[which(godbook$to == species)]))
	spt <- eval(rnumbsp)
	# here we sample until the speciation (i.e. spt) is bigger than the traject length of the leaf, because the process should be valid for speciation as for extinction.
	#
	##
	while (spt <= motherage){
		#print(paste("again.. because spt was=", spt))
		spt <- eval(rnumbsp)
	}
	# here we cut the overal sampled spt to add only the additional age
	spt <- spt-motherage
	##
	#
	#on the case of the mother, we don't sample any more extinction time, since it has been given already
	{
	if (motherage + spt <= godbook$destiny[which(godbook$to == species)])
	{
		status <- "sp" #occurred an speciation
		edge.length <- c(edge.length, spt)
		leaves <- c(leaves, (nextsp - i))
		godbook$to[which(godbook$to == species)] <- nextsp -i
	}
	else
	{
		status <- "ext" #occurred an extinction
		edge.length <- c(edge.length, godbook$destiny[which(godbook$to == species)]  - sum(  trajectoryuntil(species,  godbook$from[which(godbook$to == species)])))
		extinct <- c(extinct, (nextsp - i))
		godbook$status[which(godbook$to == species)] <- status
	}
	}
	#
	traject <- trajectory(nextsp - i)
	{
	if ( sum(traject) >= age) 
	{
		edge.length[length(edge.length)] <- age - sum(traject[1: (length(traject)-1) ] ) # reduce the last edge.length to make the sum be equals age
	# now we see if it extincted or speciated to know from were to take it out and put into the realleaves
		{
		if (status == "sp")
		{
			realleaves <- c( realleaves, leaves[length(leaves)])
			leaves <- leaves[-length(leaves)]					
		}
			else
		{
			realleaves <- c( realleaves, extinct[length(extinct)])			
			extinct <- extinct[-length(extinct)]
		}
		}
	}  
	}
	#for the child birth
	i <- 2
	edge <- rbind( edge, c(species, (nextsp - i)))
	spt <- eval(rnumbsp)
	#to remove NaN warnings messages
	{
	if (distributionextparameters[1] == 0)
	{
		extt <- suppressWarnings(eval(rnumbext))
	}
	else
	{
		extt <- eval(rnumbext)
	}
	}
	# if to see if the user simulates with extinction = ZERO and avoid error generated by expression-distribution when rate equals zero
	{
	if (is.nan(extt))
	{
		extt <- age +1 #  we add 1 to age so that an extinction event will never happen
	}
	}
	godbook$from <- c(godbook$from, species)
	godbook$to <- c(godbook$to, nextsp - i)	
	godbook$destiny <- c(godbook$destiny, extt)
	{
	if (spt <= extt)
	{
		status <- "sp" #occurred an speciation
		edge.length <- c(edge.length, spt)
		leaves <- c(leaves, (nextsp - i))
	}
	else
	{
		status <- "ext" #occurred an extinction
		edge.length <- c(edge.length, extt)
		extinct <- c(extinct, (nextsp - i))
	}
	}
	godbook$status <- c(godbook$status, status)
	#
	traject <- trajectory(nextsp - i)
	{
	if ( sum(traject) >= age) 
	{
		edge.length[length(edge.length)] <- age - sum(traject[1: (length(traject)-1)]) # reduce the last edge.length to make the sum be equals age
	# now we see if it extincted or speciated to know from were to take it out and put into the realleaves
		{
		if (status == "sp")
		{
			realleaves <- c( realleaves, leaves[length(leaves)])
			leaves <- leaves[-length(leaves)]					
		}
			else
		{
			realleaves <- c( realleaves, extinct[length(extinct)])			
			extinct <- extinct[-length(extinct)]
		}
		}
	}  
	}	

	leaves <- leaves[-1]
	{
	if (length(leaves) == 0)
	{
		stop <- TRUE	
	}
	}
}
# final if... in case of (stop == TRUE) , we write the tree "mytree"
{
if (stop == TRUE) 
{
		#### replacing to the ape format
		prealleaves <- realleaves
		{
		if (length(realleaves) > 0)
		{
				realleaves <- c(1:length(realleaves))
				i <- 1
				for (i in 1:length(realleaves))
				{
						edge[ which(edge[,2] == prealleaves[i]), 2 ] <- realleaves[i]
				}
      	tip.label <- paste(labellivingsp, realleaves, sep = "")
      	}
      	}
		pextinct <- extinct
		{
      	if (length(extinct) > 0)
      	{
			extinct <- c((length(realleaves)+1):(length(realleaves)+length(extinct)))
			i <- 1
			for (i in 1:length(extinct))
			{
					edge[ which(edge[,2] == pextinct[i]), 2 ] <- extinct[i]
			}
		tip.label <- c(tip.label, paste(labelextinctsp, extinct, sep = ""))
		}
		}
		#regarding the edges that lead to an extinct or leaving final species, but are not the final edges
		potheredges <- levels(as.factor(edge[edge <0]))
		otheredges <- rev(seq((max(realleaves, extinct)+1), length.out=length(potheredges)))
		i <- 1
		for (i in 1:length(potheredges))
		{
				edge[ edge == potheredges[i] ] <- otheredges[i]
		}
	mytree$edge <- edge
	mytree$tip.label <- tip.label
	mytree$edge.length <- edge.length
	mytree$Nnode <-  length(realleaves) + length(extinct)
	mytree$root.edge <- edge.length[1]
	mytree$age <- age
}	
}

#final handling before plotting to handle ape limitations
{
if (length(realleaves) == 0)
{
	# in case no specie is surviving until final simulation time
	mytree <- 0
}
else
{
	{
	if ( length(realleaves) == 1 & complete == FALSE)
	{
		#in case only one specie is surviving, even if other speciations events occurred in the history
		mytree <- 1
	}
	else
	{
		{
		if (length(realleaves)==1 & length(extinct)==0 & complete==TRUE)
		{
			#in case only one species is surviving and was the only one that existed
			mytree <- 1
		}
		else
		{
			#in case non of the above condition is fulfilled, there will be a tree with no initial branch, tree starts at the MRCA
			#this is done to be aple to plot with the`ape` package 
			mytree <- collapse.singles(mytree)
			#checking status of 'complete' and take or don’t take extincted species out of final tree
			{
			if (complete == FALSE)	
			{
				mytree<- drop.fossil(mytree)
			}
			}		
		}
		}		
	}
	}	
}
}
return(mytree)
}
