% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_numbering.R
\name{RenumberTips}
\alias{RenumberTips}
\title{Reorder tips}
\usage{
RenumberTips(tree, tipOrder)
}
\arguments{
\item{tree}{A tree of class \code{\link{phylo}}.}

\item{tipOrder}{A character vector containing the values of
\code{tree$tip.label} in the desired sort order}
}
\description{
\code{RenumberTips(tree, tipOrder)} sorts the tips of a phylogenetic tree
such that the indices in \code{tree$edge[, 2]} correspond to the order of
tips given in \code{tipOrder}
}
\examples{
data(Lobo) # Loads the phyDat object Lobo.phy
tree <- RandomTree(Lobo.phy)
tree <- RenumberTips(tree, names(Lobo.phy))

}
\author{
Martin R. Smith
}
