% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{tlsCrop}
\alias{tlsCrop}
\title{Point cloud cropping}
\usage{
tlsCrop(las, x, y, len, circle = TRUE, negative = FALSE)
}
\arguments{
\item{las}{\code{LAS} object.}

\item{x, y}{\code{numeric} -  X and Y center coordinates of the area to be cropped.}

\item{len}{\code{numeric} -  if \code{circle = TRUE}, \code{len} is the circle's radius, otherwise it is the side length of a square.}

\item{circle}{\code{logical} -  if \code{TRUE} (default), crops a circle, otherwise a square.}

\item{negative}{\code{logical} - if \code{TRUE}, returns all points outside the specified circle/square boundaries, otherwise returns all points inside the circle/square (default).}
}
\value{
\code{LAS} object.
}
\description{
Returns a cropped point cloud of all points inside or outside specified boundaries of circle or square shapes.
}
\examples{
file = system.file("extdata", "model_boles.laz", package="TreeLS")
tls = readTLS(file)
plot(tls)

tls = tlsCrop(tls, 2, 3, 1.5, TRUE, TRUE)
plot(tls)

tls = tlsCrop(tls, 15, 10, 3, FALSE, FALSE)
plot(tls)
}
