% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OWMeratniaBy.R
\docType{methods}
\name{owMeratniaBy}
\alias{owMeratniaBy}
\alias{owMeratniaBy,Track,numeric,numeric-method}
\title{Ow Meratnia By}
\usage{
owMeratniaBy(A1, dist, speed)

\S4method{owMeratniaBy}{Track,numeric,numeric}(A1, dist, speed)
}
\arguments{
\item{A1}{Represents a single trajectory followed by a person, animal or object.}

\item{dist}{Distance time series}

\item{speed}{Speed of track}
}
\value{
Reduces trajectories spatiotemporally
}
\description{
Method that reduces trajectories spatiotemporally
}
\examples{

\dontrun{
library(ggplot2)

speed <- max (A1@connections$speed)

distance <- max (A1@connections$distance)

ow <- owMeratniaBy(A1,distance,speed)

df <- data.frame(x=ow@sp@coords[,1],y=ow@sp@coords[,2])

ggplot(df,aes(x=df$x,y=df$y))+geom_path(aes(group = 1), arrow = arrow(),color='blue')
}
}
\author{
Diego Monteiro
}
