% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biascor.R
\name{biascor}
\alias{biascor}
\title{Bias Correction of Sample Covariance of Residuals}
\usage{
biascor(rho, Omega.list, k = 1)
}
\arguments{
\item{rho}{matrix of sample covariance of residuals (includes diagnoal), e.g., output of \code{\link{covres}}.}

\item{Omega.list}{list of precision matrices of tensor, i.e., \code{Omega.list[[k]]} is the precision matrix 
for the kth tensor mode, \eqn{k \in \{1 , \ldots, K\}}{ 1 <= k <= K }. For example, output of \code{link{Tlasso.fit}}.}

\item{k}{index of interested mode, default is 1.}
}
\value{
A matrix whose (i,j) entry (excludes diagnoal; diagnoal is zero vector) is bias-corrected sample covariance of the ith and jth residuals in the kth mode. See \href{http://arxiv.org/abs/1609.04522}{Sun et al. (2016)} for details.
}
\description{
Generate a matrix of bias-corrected sample covariance of residuals (excludes diagnoal) described in \href{http://arxiv.org/abs/1609.04522}{Sun et al. (2016)}.
}
\details{
This function computes bias-corrected sample covariance of residuals (excludes diagnoal, diagnoal is zero vector). 
Note that output matrix excludes diagnoal while sample covariance of residuals includes diagnoal, see \href{http://arxiv.org/abs/1609.04522}{Sun et al. (2016)} for details. 
Elements in \code{Omega.list} are true precision matrices or estimation of the true ones, the latter can be output of \code{\link{Tlasso.fit}}.
}
\examples{

m.vec = c(5,5,5)  # dimensionality of a tensor 
n = 5   # sample size 
k=1 # index of interested mode
lambda.thm = 20*c( sqrt(log(m.vec[1])/(n*prod(m.vec))), 
                   sqrt(log(m.vec[2])/(n*prod(m.vec))), 
                   sqrt(log(m.vec[3])/(n*prod(m.vec))))
DATA=Trnorm(n,m.vec,type='Chain') 
# obersavations from tensor normal distribution
out.tlasso = Tlasso.fit(DATA,T=1,lambda.vec = lambda.thm)   
# output is a list of estimation of precision matrices

rho=covres(DATA, out.tlasso, k = k) 
# sample covariance of residuals, including diagnoal 
bias_rho=biascor(rho,out.tlasso,k=k)
bias_rho # bias-corrected sample covariance of residuals
# diagnoal is zero vector

}
\author{
Will Wei Sun, Zhaoran Wang, Xiang Lyu, Han Liu, Guang Cheng.
}
\seealso{
\code{\link{varcor}}, \code{\link{covres}}
}

