% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ChainOmega.R
\name{ChainOmega}
\alias{ChainOmega}
\title{Precision Matrix of Triangle Graph}
\usage{
ChainOmega(p, sd = 1, norm.type = 2)
}
\arguments{
\item{p}{dimension of generated precision matrix.}

\item{sd}{seed for random number generation, default is 1.}

\item{norm.type}{normalization methods of generated precision matrix, i.e., \eqn{\Omega_{11} = 1}{\Omega_{11}=1} 
if norm.type = 1 and \eqn{\|\Omega\|_{F}=1}{||\Omega||_F =1 } if norm.type = 2. Default value is 2.}
}
\value{
A precision matrix generated from triangle graph.
}
\description{
Generate precision matrix of triangle graph (chain like network) following the set-up in \href{http://arxiv.org/abs/0908.2053}{Fan et al. (2009)}.
}
\details{
This function first construct a covariance matrix \eqn{\Sigma}{\Sigma} that its (i,j) entry is 
\eqn{\exp (- | h_i - h_j |/2)}{exp (- | h_i - h_j | / 2)} with \eqn{h_1 < h_2 < \ldots < h_p}{h_1 < h_2 < \ldots < h_p}.
The difference \eqn{h_i - h_{i+1}}{h_i - h_{i+1}} is generated i.i.d. from Unif(0.5,1). See \href{http://arxiv.org/abs/0908.2053}{Fan et al. (2009)} 
for more details.
}
\examples{

m.vec = c(5,5,5)  # dimensionality of a tensor 
n = 5   # sample size 

Omega.true.list = list()

for ( k in 1:length(m.vec)){
 Omega.true.list[[k]] = ChainOmega(m.vec[k],sd=k*100,norm.type=2)
}
Omega.true.list  # a list of length 3 contains precision matrices from triangle graph

}
\author{
Will Wei Sun, Zhaoran Wang, Xiang Lyu, Han Liu, Guang Cheng.
}
\seealso{
\code{\link{NeighborOmega}}
}

