% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts.forecast.R
\name{ts.forecast}
\alias{ts.forecast}
\title{Time series forecast results of OBEU Time Series}
\usage{
ts.forecast(ts_modelx, h=1, tojson=F)
}
\arguments{
\item{ts_modelx}{The input univariate time series data}

\item{h}{The number of prediction steps}

\item{tojson}{If TRUE the results are returned in json format, default returns a list}
}
\value{
A list with the parameters:

\itemize{ 

\item ts.model a string indicating the arima orders

\item data_year The time that time series data were sampled

\item data The time series values
\item predict_time The time that defined by the prediction_steps parameter
\item predict_values The predicted values that defined by the prediction_steps parameter
\item up80: The upper limit of the 80\% predicted confidence interval
\item low80: The lower limit of the 80\% predicted confidence interval
\item up95: The upper limit of the 95\% predicted confidence interval
\item low95: The lower limit of the 95\% predicted confidence interval}
}
\description{
Univariate time series forecasts for short and long time series data using the appropriate model.
}
\details{
This function is used internally in ts.analysis and forecasts the model 
that fits the input data using the auto.arima function(see forecast package). 
The model selection depends on the results of some diagnostic tests (acf,pacf,pp adf and kpss).
For short time series the selected arima model is among various orders of the AR part using 
the first differences and the first order moving average component, with the lower AIC value.
}
\examples{
Athens_draft <- ts.non.seas.model(Athens_draft_ts)
#Hold the model object of non seasonal modeling
draft<-Athens_draft$model.summary 
ts.forecast(draft)

}
\seealso{
\code{\link{ts.analysis}}, \code{\link[forecast]{forecast}}
}
\author{
Kleanthis Koupidis
}
