% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TileHandlers.R
\name{TileApply}
\alias{TileApply}
\title{Tile Apply}
\usage{
TileApply(inList, maxCells, tileBuffer = 0, verbose = FALSE)
}
\arguments{
\item{inList}{a list of RasterLayers. Either a single raster (for which a tiling scheme may or may
not be applied) or a list of existing tiles (for which a tiling scheme will be detected)}

\item{maxCells}{numeric. The maximum number of cells that an input raster may have before it is broken
up into multiple tiles}

\item{tileBuffer}{numeric. Number of buffer cells to be applied to tiles}

\item{verbose}{logical. Report progress}
}
\value{
The output of this function is a list of three \link[sp]{SpatialPolygonsDataFrame} objects:
  \item{tilePolygons}{The tiling grid. Each polygon corresponds to the extent of a single unbuffered tile.}
  \item{buffPolygons}{The buffered tiling grid. Each polygon corresponds to the extent of a buffered tile. These
  polygons overlap with neighboring tiles. If \code{buffer} is set to 0, this output will be identical to \code{tilePolygons}.}
  \item{nbuffPolygons}{Non-overlapping buffered tiles. These polygons remove overlapping buffers for adjacent tiles, but
  preserve buffers for tiles on the edges of the tiling grid. Useful for "reassembling" data that had been originally broken
  into tiles.}
}
\description{
A function for applying a tile scheme if an input raster exceeds a given number of cells.
}
\details{
Tiling schemes are frequently used to break up rasters that are too large to be read into memory.
This function takes a value for \code{maxCells}, and breaks up any raster that exceeds that cell
count into tiles using \code{\link{TileScheme}}. The tiles themselves have a number of cells equal
to \code{maxCells}, and can also be given buffers using the \code{tileBuffer} argument. If the
input raster does not exceed \code{maxCells}, then a tiling scheme with a single tile will be
returned.

If a list of RasterLayers is given that already correspond to a set of tiles,
\code{\link{TileDetector}} will be used to detect the existing tiling scheme.

Input for \code{TileApply} should be a list of RasterLayers, and so would typically be used
in conjunction with \code{\link{TileInput}}.
}
\seealso{
\code{\link{TileInput}} \code{\link{TileScheme}} \code{\link{TileDetector}}
}
