/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.net.URLDecoder;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public class TiddlySaver
extends Applet {
    private static final boolean debug = false;
    private static final boolean restrictToSameDirectory = true;
    private static final boolean allowSystemProperties = false;
    private String lastErrorMsg;
    private String lastErrorStackTrace;
    private StringBuilder debugMsg = new StringBuilder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String loadFile(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            FileInputStream fileInputStream = this.privInputStream(string);
            try {
                InputStreamReader inputStreamReader = TiddlySaver.isNullOrEmpty(string2) ? new InputStreamReader(fileInputStream) : new InputStreamReader((InputStream)fileInputStream, string2);
                try {
                    int n;
                    char[] cArray = new char[4096];
                    while ((n = inputStreamReader.read(cArray)) >= 0) {
                        stringBuilder.append(cArray, 0, n);
                    }
                }
                finally {
                    inputStreamReader.close();
                }
            }
            finally {
                fileInputStream.close();
            }
        }
        catch (Exception exception) {
            this.logAndRethrow("loadFile", exception);
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int saveFile(String string, String string2, String string3) {
        try {
            FileOutputStream fileOutputStream = this.privOutputStream(string);
            try {
                OutputStreamWriter outputStreamWriter = TiddlySaver.isNullOrEmpty(string2) ? new OutputStreamWriter(fileOutputStream) : new OutputStreamWriter((OutputStream)fileOutputStream, string2);
                try {
                    outputStreamWriter.write(string3);
                }
                finally {
                    outputStreamWriter.close();
                }
            }
            finally {
                ((OutputStream)fileOutputStream).close();
            }
        }
        catch (Exception exception) {
            this.logAndRethrow("saveFile", exception);
        }
        return 1;
    }

    public boolean exists(String string) {
        boolean bl = false;
        try {
            bl = this.privExists(string);
        }
        catch (Exception exception) {
            this.logAndRethrow("exists", exception);
        }
        return bl;
    }

    public long modificationTime(String string) {
        long l = 0L;
        try {
            l = this.privModificationTime(string);
            if (l == 0L) {
                throw new IOException("Unable to get file modification time: " + string);
            }
        }
        catch (Exception exception) {
            this.logAndRethrow("modificationTime", exception);
        }
        return l;
    }

    public String[] listFiles(String string) {
        String[] stringArray = null;
        try {
            stringArray = this.privList(string);
            if (stringArray == null) {
                throw new IOException("Not a directory:" + string);
            }
        }
        catch (Exception exception) {
            this.logAndRethrow("listFiles", exception);
        }
        return stringArray;
    }

    public String getJavaVersion() {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("java.version");
            }
        });
    }

    public String getSystemProperties() {
        return "";
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || "".equals(string.trim());
    }

    private FileInputStream privInputStream(final String string) throws PrivilegedActionException {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<FileInputStream>(){

            @Override
            public FileInputStream run() throws Exception {
                return new FileInputStream(TiddlySaver.this.resolveFilename(string));
            }
        });
    }

    private FileOutputStream privOutputStream(final String string) throws PrivilegedActionException {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<FileOutputStream>(){

            @Override
            public FileOutputStream run() throws Exception {
                File file = TiddlySaver.this.resolveFilename(string);
                File file2 = file.getParentFile();
                if (file2 != null && !file2.exists() && !file2.mkdirs()) {
                    throw new IOException("Unable to create directory for: " + string);
                }
                return new FileOutputStream(file);
            }
        });
    }

    private boolean privExists(final String string) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                File file = TiddlySaver.this.resolveFilename(string);
                return file.exists();
            }
        });
    }

    private long privModificationTime(final String string) {
        return AccessController.doPrivileged(new PrivilegedAction<Long>(){

            @Override
            public Long run() {
                File file = TiddlySaver.this.resolveFilename(string);
                return file.lastModified();
            }
        });
    }

    private String[] privList(final String string) {
        return AccessController.doPrivileged(new PrivilegedAction<String[]>(){

            @Override
            public String[] run() {
                File file = TiddlySaver.this.resolveFilename(string);
                return file.list();
            }
        });
    }

    public String getLastErrorMsg() {
        return this.lastErrorMsg;
    }

    public String getLastErrorStackTrace() {
        return this.lastErrorStackTrace;
    }

    private void logAndRethrow(String string, Exception exception) {
        Throwable throwable = exception;
        while (throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        this.lastErrorMsg = throwable.toString();
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter((Writer)stringWriter, false);
        throwable.printStackTrace(printWriter);
        printWriter.flush();
        this.lastErrorStackTrace = stringWriter.toString();
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        throw new RuntimeException(exception);
    }

    public final File resolveFilename(String string) {
        this.debugMsg.setLength(0);
        this.debug("Filename:", string);
        string = TiddlySaver.utf8DecodeHack(string);
        this.debug("UTF8DecodeHack:", string);
        try {
            File file = new File(string);
            URL uRL = this.getCodeBase();
            this.debug("Codebase:", uRL);
            if (!"file".equals(uRL.getProtocol())) {
                throw new RuntimeException("TiddlySaver did not come from file:///, refusing");
            }
            File file2 = this.privCanonicalFile(file);
            String string2 = URLDecoder.decode(uRL.getPath());
            this.debug("dirpath:", string2);
            string2 = TiddlySaver.utf8DecodeHack(string2);
            this.debug("dirpath decodeHack:", string2);
            File file3 = this.privCanonicalFile(new File(string2));
            String string3 = file2.toURI().toString();
            String string4 = file3.toURI().toString();
            this.debug("canonicalURL:", string3);
            this.debug("canonicalDirURL", string4);
            if (!string3.startsWith(string4)) {
                throw new RuntimeException("File: " + string3 + " is not in directory " + string4);
            }
            return file;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new RuntimeException(exception);
        }
    }

    private File privCanonicalFile(final File file) throws PrivilegedActionException {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<File>(){

            @Override
            public File run() throws Exception {
                return file.getCanonicalFile();
            }
        });
    }

    private void debug(Object ... objectArray) {
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            this.debugMsg.append(objectArray[i].toString());
            if (i < n - 1) {
                this.debugMsg.append(" ");
                continue;
            }
            this.debugMsg.append("\n");
        }
    }

    public String getDebugMsg() {
        return this.debugMsg.toString();
    }

    private static String utf8DecodeHack(String string) {
        try {
            byte[] byArray = string.getBytes("ISO-8859-1");
            String string2 = new String(byArray, "UTF-8");
            if (string2.indexOf("\ufffd") != -1) {
                return string;
            }
            return string2;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.out.println("Exception " + unsupportedEncodingException);
            return string;
        }
    }
}

