% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotBoxesByFactor.R
\name{plotBoxesByFactor}
\alias{plotBoxesByFactor}
\title{Layout of box-plots: variables by factor}
\usage{
plotBoxesByFactor(xVars, groups, ncol=3, zTrans=TRUE, varwidth=FALSE)
}
\arguments{
\item{xVars}{data-frame of metric variables.}

\item{groups}{factor variable.}

\item{ncol}{number of layout columnes.}

\item{zTrans}{logical. \code{xTrans=TRUE} performs a z-transformation of all
variables.}

\item{varwidth}{logical. \code{varwidth=TRUE} makes the box width proportional
to the number of observation used to generate the box for a specific factor
level.}
}
\description{
\code{plotBoxesByFactor} generates box-plots of several variable by a factor.
}
\details{
This function organizes several box-plots of metric variables broken
by a factor variable in to a layout. By default 3 box-plots are shown
per row and the variables are standardized by the z-transformation. As the number
of factor levels increases the number of plots per row should be decreased to maintain
a reasonable visual resolution.
}
\examples{
varsKeep <- c("PCTWHITE","PCTBLACK","PCTASIAN","PCTHISPAN","MEDAGE","MEDVALHOME")
myData <- tractShp@data
plotBoxesByFactor(myData[,varsKeep], tractShp$CITYPERI, ncol=2, zTrans=TRUE, varwidth=FALSE)
}
\author{
Michael Tiefelsdorf <tiefelsdorf@utdallas.edu>
}
