% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accu_model.R
\name{accu_model}
\alias{accu_model}
\title{Evaluation Of Sex prediction Accuracy}
\usage{
accu_model(
  f,
  x,
  y = NULL,
  method = "lda",
  res_method = "repeatedcv",
  p = 0.75,
  nf = 10,
  nr = 3,
  plot = FALSE,
  Sex = 1,
  Pop = NULL,
  byPop = FALSE,
  ref. = "F",
  post. = "M",
  ...
)
}
\arguments{
\item{f}{Formula in the form \code{groups ~ x1 + x2 + ...}. The grouping factor
is placed to the left hand side while the numerical measurements are placed
to the right hand side}

\item{x}{Data frame to be fitted to the model}

\item{y}{New data frame to be tested, if \code{NULL} \code{x} is splitted to test and
training data seta, Default: NULL}

\item{method}{A string specifying which classification or regression model
to use,}

\item{res_method}{The resampling method used by
\link[caret:trainControl]{trainControl}, Default: 'repeatedcv'}

\item{p}{Percentage of \code{x} for testing the model in case \code{y} is NULL,
Default: 0.75}

\item{nf}{number of folds or of resampling iterations, Default: 10}

\item{nr}{Number of repeats for repeated k fold cross validation, Default:
3}

\item{plot}{Logical; if TRUE returns an roc curve for model accuracy,
Default:
FALSE}

\item{Sex}{Number of the column containing sex 'M' for male and 'F' for
female, Default: 1}

\item{Pop}{Number of the column containing populations' names, Default:
NULL}

\item{byPop}{Logical; if TRUE returns the accuracy in different populations
of the new data frame, Default: FALSE.}

\item{ref.}{reference category in the grouping factor, Default: 'F'}

\item{post.}{positive category in the grouping factor, Default: 'M'}

\item{...}{additional arguments that can passed to modeling,
\link[caret:confusionMatrix]{confusionMatrix} function and roc curve generated
by \link[cutpointr:plot_roc]{plot_roc}}
}
\value{
Visual and numerical accuracy parameters for the tested model
}
\description{
Testing, cross validation and visualization of the accuracy of
different sex prediction models using the
\link[caret:confusionMatrix]{confusionMatrix} and roc curves
}
\details{
Data frames to be entered as input need to be arranged in a
similar manner to \link{Howells} dataset.
}
\examples{
\donttest{
# Using a single dataset
library(TestDimorph)
accu_model(
  Sex ~ GOL + NOL + BNL,
  x = Howells,
  method = "lda",
  plot = FALSE
)
}
}
\seealso{
\code{\link[cutpointr:plot_roc]{cutpointr::plot_roc()}}
\code{\link[caret:confusionMatrix]{caret::confusionMatrix()}}
}
