% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/static_functions.R
\docType{methods}
\name{Static}
\alias{Static}
\alias{Static,config_Static-method}
\title{Run fixed-form test assembly}
\usage{
Static(config, constraints, force_solver = FALSE)

\S4method{Static}{config_Static}(config, constraints, force_solver = FALSE)
}
\arguments{
\item{config}{a \code{\linkS4class{config_Static}} object. Use \code{\link{createStaticTestConfig}} for this.}

\item{constraints}{a \code{\linkS4class{constraints}} object representing test specifications. Use \code{\link{loadConstraints}} for this.}

\item{force_solver}{if \code{TRUE}, do not check whether the solver is one of recommended solvers for doing set-based assembly. Has no effect on discrete assembly. (default = \code{FALSE})}
}
\value{
\code{\link{Static}} returns a \code{\linkS4class{output_Static}} object containing the selected items.
}
\description{
\code{\link{Static}} is a test assembly function to perform fixed-form test assembly based on the generalized shadow-test framework.
}
\examples{
config_science <- createStaticTestConfig(
  list(
    method = "MAXINFO",
    target_location = c(-1, 1)
  )
)
solution <- Static(config_science, constraints_science)

}
\references{
van der Linden, W. J. (2005).
\emph{Linear models for optimal test design.}
Springer Science & Business Media.
}
