% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solver_functions.R
\name{runAssembly}
\alias{runAssembly}
\title{Run Test Assembly}
\usage{
runAssembly(config, constraints, xdata = NULL, objective = NULL)
}
\arguments{
\item{config}{A \code{\linkS4class{config_Static}} or a \code{\linkS4class{config_Shadow}} object containing configuration options. Use \code{\link{createStaticTestConfig}} and \code{\link{createShadowTestConfig}} for this.}

\item{constraints}{A list representing optimization constraints. Use \code{\link{loadConstraints}} for this.}

\item{xdata}{A list containing extra data to be used in \code{\link{Shadow}}, representing the constraints for force-including previously administered items.}

\item{objective}{Information for each item in the pool.}
}
\value{
A list containing the following entries:
\itemize{
  \item{\code{MIP}} A list containing the result from MIP solver.
  \item{\code{status}} The MIP status value, indicating whether an optimal solution was found.
  \item{\code{shadow_test}} The attributes of the selected items.
  \item{\code{obj_value}} The objective value of the solution.
  \item{\code{solve_time}} The elapsed time in running the solver.
}
}
\description{
Perform test assembly with specified configurations. This function is used internally in \code{\link{Static}} and \code{\link{Shadow}}.
}
\references{
\insertRef{van_der_linden_linear_2005}{TestDesign}
}
