% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{dataset_reading}
\alias{dataset_reading}
\alias{itempool_reading_raw}
\alias{itemattrib_reading_raw}
\alias{stimattrib_reading_raw}
\alias{constraints_reading_raw}
\alias{itempool_reading}
\alias{itemattrib_reading}
\alias{stimattrib_reading}
\alias{constraints_reading}
\title{Reading dataset}
\description{
Stimulus-based example item pool (303 items).
}
\details{
This pool is associated with the following objects:
\itemize{
  \item \code{itempool_reading} An \code{\linkS4class{item_pool}} object.
  \item \code{itemattrib_reading} A data frame containing item attributes.
  \item \code{stimattrib_reading} A data frame containing stimulus attributes.
  \item \code{constraints_reading} A list containing 18 constraints.
}

Also, the following datasets are intended for illustrating expected data structures. See examples below.
\itemize{
  \item \code{itempool_reading_raw} Item parameters.
  \item \code{itemattrib_reading_raw} Item attributes.
  \item \code{stimattrib_reading_raw} Item attributes.
  \item \code{constraints_reading_raw} Constraints.
}
}
\examples{
## Write to tempdir() and clean afterwards
f <- file.path(tempdir(), "itempool_reading.csv")
write.csv(itempool_reading_raw, f, row.names = FALSE)
itempool_reading <- loadItemPool(f)
file.remove(f)

f <- file.path(tempdir(), "itemattrib_reading.csv")
write.csv(itemattrib_reading_raw, f, row.names = FALSE)
itemattrib_reading <- loadItemAttrib(f, itempool_reading)
file.remove(f)

f <- file.path(tempdir(), "stimattrib_reading.csv")
write.csv(stimattrib_reading_raw, f, row.names = FALSE)
stimattrib_reading <- loadStAttrib(f, itemattrib_reading)
file.remove(f)

f <- file.path(tempdir(), "constraints_reading.csv")
write.csv(constraints_reading_raw, f, row.names = FALSE)
constraints_reading <- loadConstraints(f,
  itempool_reading, itemattrib_reading, stimattrib_reading)
file.remove(f)

}
\keyword{datasets}
