% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shadow_functions.R
\docType{methods}
\name{Shadow}
\alias{Shadow}
\alias{Shadow,config_Shadow-method}
\title{Run adaptive test assembly.}
\usage{
Shadow(config, constraints = NULL, true_theta = NULL, data = NULL,
  prior = NULL, prior_par = NULL, session = NULL)

\S4method{Shadow}{config_Shadow}(config, constraints = NULL,
  true_theta = NULL, data = NULL, prior = NULL, prior_par = NULL,
  session = NULL)
}
\arguments{
\item{config}{A \code{\linkS4class{config_Shadow}} object.}

\item{constraints}{A list representing optimization constraints. Use \code{\link{loadConstraints}} for this.}

\item{true_theta}{Numeric. A vector of true theta values to be used in simulation.}

\item{data}{Numeric. A matrix containing item response data.}

\item{prior}{Numeric. A matrix or a vector containing priors.}

\item{prior_par}{Numeric. A vector of parameters for prior distribution.}

\item{session}{Used to communicate with a Shiny session.}
}
\description{
Perform adaptive test assembly based on generalized shadow-test approach, with specified configurations.
}
\examples{
config <- createShadowTestConfig()
true_theta <- rnorm(1)
solution <- Shadow(config, constraints_science, true_theta)
solution$output
}
\references{
{
  \insertRef{van_der_linden_model_1998}{TestDesign}

  \insertRef{van_der_linden_optimal_1998}{TestDesign}

  \insertRef{van_der_linden_optimal_2000}{TestDesign}

  \insertRef{van_der_linden_linear_2005}{TestDesign}
}
}
