% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Coordinates.R
\name{OutsidePlot}
\alias{OutsidePlot}
\title{Is a point in the plotting area?}
\usage{
OutsidePlot(x, y, tolerance = 0)
}
\arguments{
\item{x, y}{Vectors of \emph{x} and \emph{y} coordinates of points.}

\item{tolerance}{Consider points this close to the edge of the plot to be
inside.  Set to negative values to count points that are just outside the
plot as inside, and to positive values to count points that are just inside
the margins as outside. Maximum positive value: 1/3.}
}
\value{
\code{OutsidePlot()} returns a logical vector specifying whether each
pair of \emph{x} and \emph{y} coordinates corresponds to a point outside the plotted
ternary diagram.
}
\description{
Evaluate whether a given set of coordinates lie outwith the boundaries of
a plotted ternary diagram.
}
\examples{

TernaryPlot()
points(0.5, 0.5, col = 'darkgreen')
OutsidePlot(0.5, 0.5)
 
points(0.1, 0.5, col = 'red')
OutsidePlot(0.1, 0.5)

OutsidePlot(c(0.5, 0.1), 0.5) 

}
\seealso{
Other plot limits: \code{\link{TernaryXRange}}
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{plot limits}
