% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basicfcts_TS.R
\name{dTSS}
\alias{dTSS}
\title{Density function of the tempered stable subordinator (TSS) distribution}
\usage{
dTSS(x, alpha = NULL, delta = NULL, lambda = NULL, theta = NULL)
}
\arguments{
\item{x}{A numeric vector of positive quantiles.}

\item{alpha}{Stability parameter. A real number between 0 and 1.}

\item{delta}{Scale parameter. A real number > 0.}

\item{lambda}{Tempering parameter. A real number > 0.}

\item{theta}{Parameters stacked as a vector.}
}
\value{
As \code{x} is a numeric vector, the return value is also a numeric
vector of probability densities.
}
\description{
The probability density function (PDF) of tempered stable subordinator distribution.
It can be computed via the stable distribution (see details)
using the \code{stabledist} package.
}
\details{
\code{theta} denotes the parameter vector \code{(alpha, delta, lambda)}. Either provide the parameters
\code{alpha}, \code{delta}, \code{lambda} individually OR provide \code{theta}.
\deqn{f_{TSS}(y;\theta)=\mathrm{e}^{-\lambda y-\lambda^{\alpha}\delta\Gamma(-\alpha)}f_{S(\alpha,\delta)}(y),}
where \deqn{f_{S(\alpha,\delta)}} is the density of the stable subordinator.
}
\examples{
x <- seq(0,15,0.25)
y <- dTSS(x,0.5,1,0.3)
plot(x,y)

}
\references{
Massing, T. (2023), 'Parametric Estimation of Tempered Stable Laws'

Kawai, R. & Masuda, H. (2011), 'On simulation of tempered stable random
variates' \doi{10.1016/j.cam.2010.12.014}
}
