% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strip_comments.R
\name{strip_comments}
\alias{strip_comments}
\title{Strip comments from LaTeX lines}
\usage{
strip_comments(lines, retain.percent.symbol = TRUE)
}
\arguments{
\item{lines}{Character vector of a LaTeX document.}

\item{retain.percent.symbol}{(logical, default: \code{TRUE}) Should the \verb{\%} symbol itself be stripped?}
}
\value{
\code{lines} but with all text to the right of every unescaped \verb{\%} removed
}
\description{
Strip comments from LaTeX lines
}
\examples{

some_lines <- c("Text. \% A comment", "20\\\% of comments are \% useful")
strip_comments(some_lines)
strip_comments(some_lines, retain.percent.symbol = FALSE)
}
