% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.TcGSA.R
\name{summary.TcGSA}
\alias{summary.TcGSA}
\alias{print.summary.TcGSA}
\title{Summarizing TcGSA}
\usage{
\method{summary}{TcGSA}(object, ...)

\method{print}{summary.TcGSA}(x, ...)
}
\arguments{
\item{object}{an object of class '\code{TcGSA}'.}

\item{\dots}{further arguments passed to or from other methods.}

\item{x}{an object of class '\code{summary.TcGSA}'.}
}
\value{
The function summary.TcGSA returns a list with the following
components (list elements):\itemize{
\item \code{time_func} the chosen form for the time trend.
\item \code{separateSubjects} a logical flag indicating whether gene sets
tested for discriminating among patients, or for time trends over time.
\item \code{ntg} the number of treatment groups.
\item \code{ngs} the number of tested gene sets.
\item \code{nsignif} the number of significant gene sets at a 5\% FDR (using
the default Benjamini & Yekutieli step-up procedure).
}
}
\description{
\code{summary} method for class '\code{TcGSA}'
}
\examples{

\dontrun{
data(data_simu_TcGSA)

tcgsa_sim_1grp <- TcGSA.LR(expr=expr_1grp, gmt=gmt_sim, design=design, 
                          subject_name="Patient_ID", time_name="TimePoint",
                          time_func="linear", crossedRandom=FALSE)
summary(tcgsa_sim_1grp)

tcgsa_sim_2grp <- TcGSA.LR(expr=expr_2grp, gmt=gmt_sim, design=design, 
                          subject_name="Patient_ID", time_name="TimePoint",
                          time_func="linear", crossedRandom=FALSE, 
                          group_name="group.var")
summary(tcgsa_sim_2grp)
}

}
\seealso{
\code{\link{TcGSA.LR}}
}
\author{
Boris P. Hejblum
}
