\name{plot.TWIX}
\alias{plot.TWIX}
\alias{plot.bootTWIX}
\title{
  Plotting method for TWIX Objects
}
\description{
  Plot an \code{TWIX} or \code{bootTWIX} object generated by
                    TWIX  or bootTWIX function(s).}
\usage{
\method{plot}{TWIX}(x,sq = 1:length(x$trees),type = "deviance",
            i.plot = FALSE,size = 3,freq = TRUE,breaks = "Sturges",pch = par("pch"),...)}
\arguments{
  \item{x}{an object of class \code{TWIX}.}
  \item{sq}{Integer vector giving the number of trees to be plotted.}
  \item{type}{one of \code{"deviance"}, \code{"ccr"},\code{"d&c"}.}
  \item{i.plot}{logical. If \code{TRUE}, iplot will be used.}
  \item{size}{value for largest circle (\code{cex}).}
  \item{freq}{logical. Should the frequence or density be plotted.}
  \item{breaks}{see histogram.}
  \item{pch}{a vector of plotting characters or symbols.}
  \item{...}{graphical parameters can be given as arguments to 'plot'.
    Many methods will also accept the following arguments:}}
\details{
    If \code{type = "deviance"}:\cr
    the training deviance vs. test deviance will be plotted.\cr
    If \code{type = "ccr"}:\cr
    the correct classification rate(CCR) for training data vs. the CCR for test data.\cr
    If \code{type = "d&c"}:\cr
    the deviance vs. CCR for test data.
}
\seealso{
  \code{\link{TWIX}}
  \code{\link{get.tree}}
}
\examples{
  data(olives)
  i <- sample(572,150)
  ic <- setdiff(1:572,i)
  training <- olives[ic,]
  valid <- olives[i,]
  #
  #Tree<-TWIX(Region~.,training,test.data=valid,topN=c(10,2),method="local")
  #plot(Tree)
  #plot(Tree,type="ccr")
  #plot(Tree,type="d&c")
  #plot(Tree,i.plot=TRUE)
}
\keyword{tree}
