% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segVPR.R
\name{seg.VPR}
\alias{seg.VPR}
\title{Segmented Vegetation Precipitation Relationship}
\usage{
seg.VPR(anu.VI, acu.RF, VI.index, breakpoint, rf.b4, rf.af, sig = 0.05)
}
\arguments{
\item{anu.VI}{The annual (Growing season) max VI. Must be a object of class \code{'ts'} without NA's.
if anu.VI=FALSE, it will be calculated from the CTSR.VI using \code{\link{AnMaxVI}}.}

\item{acu.RF}{The optimal accumulated rainfall for anu.VI. Must be a object of class \code{'ts'} without
NA's and be of equal length and temporal range to anu.VI. if anu.RF=FALSE, it will be
calculated from ACP.table usingthe \code{\link{AnnualRF.Cal}}}

\item{VI.index}{the index of the CTSR.VI ts that the anu.VI values occur at. Must be the same length
as anu.VI. NOTE. R indexs from 1 rather than 0.
if VI.index=FALSE, it will be calculated from the CTSR.VI using \code{\link{AnMaxVI}}.}

\item{breakpoint}{The index of the most significant breakpoint as determined using \code{\link{CHOW}}.}

\item{rf.b4}{If a breakpoint in the VPR is detected this is the optimial accumulated rainfall before
the breakpoint. must be the same length as the anu.VI. If ACP.table is provided it will
be generated using \code{\link{AnnualRF.Cal}}}

\item{rf.af}{If a breakpoint in the VPR is detected this is the optimial accumulated rainfall after
the breakpoint. must be the same length as the anu.VI. If ACP.table is provided it will
be generated using \code{\link{AnnualRF.Cal}}}

\item{sig}{Significance of all the functions. defualt sig=0.05}
}
\value{
a list of class TSSRESTREND.
       See \code{\link{TSSRESTREND}} for details. Note. if called seperatly from TSSRESTREND,
       this list will be incomplete.
}
\description{
For ts with a significant breakpoints in the the VPR. Takes annual VI max, the optimal accumulated precipitation
bor and after the breakpoint, then caculated the Precipitation Standard Variance, and regresses it with a dummy
variable that is 0 before the breakpoint and 1 after it. WARNING NEED TO REMOVE acu.RF
}
\examples{
brkp <- as.integer(24) #calculated using th CHOW (DONTRUN) example
VPRres <- seg.VPR(segVPR$max.NDVI, segVPR$acum.RF, segVPR$index, brkp, segVPR$RFB4, segVPR$RFAF)
print(VPRres)
}
\author{
Arden Burrell, arden.burrell@unsw.edu.au
}

