% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emd.r
\name{emd}
\alias{emd}
\alias{emd.rev}
\title{Automatic empirical mode decomposition}
\usage{
emd(
  x,
  num_imfs = 0,
  S_number = 4L,
  num_siftings = 50L,
  meaningfulImfs = NULL,
  h = 1,
  ...
)

emd.rev(pred)
}
\arguments{
\item{x}{A numeric vector or univariate time series to be decomposed.}

\item{num_imfs}{Number of Intrinsic Mode Functions (IMFs) to compute. See \code{\link[Rlibeemd]{emd}}.}

\item{S_number, num_siftings}{See \code{\link[Rlibeemd]{emd}}.}

\item{meaningfulImfs}{Vector indicating the indices of the meaningful IMFs according to the
possible intervals \code{i:num_imfs} for \code{i=1,...,(num_imfs-1)}, where
\code{num_imfs} is the number of IMFs in a decomposition.
If \code{meaningfulImfs = NULL} (default), the function returns all IMF's produced by \code{\link[Rlibeemd]{emd}} as meaningful.
If \code{meaningfulImfs = 0} the function automatically selects the meaningful IMFs of
a decomposition using \code{\link{fittestEMD}}.}

\item{h}{See \code{\link{fittestEMD}}. Passed to \code{\link{fittestEMD}} if \code{meaningfulImfs = 0}.}

\item{...}{Additional arguments passed to \code{\link{fittestEMD}}.}

\item{pred}{A list containing IMFs produced by empirical mode decomposition.}
}
\value{
A list containing the meaningful IMFs of the empirical mode decomposition of \code{x}.
A vector indicating the indices of the meaningful IMFs and the number of IMFs produced are passed as attributes
named "meaningfulImfs" and "num_imfs", respectively.
}
\description{
The function automatically applies an empirical mode decomposition to a
provided univariate time series. Wrapper function for \code{\link[Rlibeemd]{emd}}
of the \code{Rlibeemd} package. It also allows the automatic selection
of meaningful IMFs using \code{\link{fittestEMD}}.
\code{emd.rev()} reverses the transformation.
}
\examples{

data(CATS)
e <- emd(CATS[,1])
x <- emd.rev(e)
all(round(x,4)==round(CATS[,1],4))

}
\references{
Kim, D., Paek, S. H., & Oh, H. S. (2008). A Hilbert-Huang
transform approach for predicting cyber-attacks. Journal of the Korean
Statistical Society, 37(3), 277-283.
}
\seealso{
\code{\link{fittestEMD}}, \code{\link{fittestWavelet}}

Other transformation methods: 
\code{\link{Diff}()},
\code{\link{LogT}()},
\code{\link{WaveletT}()},
\code{\link{mas}()},
\code{\link{mlm_io}()},
\code{\link{outliers_bp}()},
\code{\link{pct}()},
\code{\link{train_test_subset}()}
}
\author{
Rebecca Pontes Salles
}
\concept{transformation methods}
\keyword{Imfs}
\keyword{decomposition}
\keyword{emd}
\keyword{meaningful}
\keyword{transform}
