% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MAXError.R
\name{MAXError}
\alias{MAXError}
\title{Maximal error of prediction}
\usage{
MAXError(actual, prediction)
}
\arguments{
\item{actual}{A vector or univariate time series containing actual values
for a time series that are to be compared against its respective
predictions.}

\item{prediction}{A vector or univariate time series containing time series
predictions that are to be compared against the values in \code{actual}.}
}
\value{
A numeric value of the maximal error of prediction.
}
\description{
The function calculates the maximal error between actual and predicted
values.
}
\examples{

data(SantaFe.A,SantaFe.A.cont)
pred <- marimapred(SantaFe.A,n.ahead=100)
MAXError(SantaFe.A.cont[,1], pred)

}
\seealso{
\code{\link{sMAPE}}, \code{\link{MAPE}}
}
\author{
Rebecca Pontes Salles
}
\keyword{error}
\keyword{maximal}
\keyword{prediction}
