% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processing_subclasses.r
\name{LT}
\alias{LT}
\alias{BoxCoxT}
\alias{WT}
\alias{subsetting}
\alias{SW}
\alias{NAS}
\alias{MinMax}
\alias{AN}
\alias{DIFF}
\alias{MAS}
\alias{PCT}
\alias{EMD}
\title{Time series transformation methods}
\usage{
LT(base = exp(1))

BoxCoxT(lambda = NULL, prep_par = NULL, postp_par = NULL, ...)

WT(
  level = NULL,
  filter = NULL,
  boundary = "periodic",
  prep_par = NULL,
  postp_par = NULL,
  ...
)

subsetting(train_perc = 0.8, test_len = NULL)

SW(window_len = NULL)

NAS(na.action = stats::na.omit, prep_par = NULL)

MinMax(min = NULL, max = NULL, byRow = TRUE)

AN(min = NULL, max = NULL, byRow = TRUE, outlier.rm = TRUE, alpha = 1.5)

DIFF(
  lag = NULL,
  differences = NULL,
  type = "simple",
  postp_par = list(addinit = FALSE)
)

MAS(order = NULL, prep_par = NULL, postp_par = list(addinit = FALSE))

PCT(postp_par = NULL)

EMD(num_imfs = 0, meaningfulImfs = NULL, prep_par = NULL)
}
\arguments{
\item{base}{\code{\link[TSPred]{LogT}}}

\item{lambda}{See \code{\link[TSPred]{BCT}}}

\item{prep_par}{List of named parameters required by \code{prep_func}.}

\item{postp_par}{List of named parameters required by \code{postp_func}.}

\item{...}{Other parameters to be encapsulated in the class object.}

\item{level}{See \code{\link[TSPred]{WaveletT}}}

\item{filter}{See \code{\link[TSPred]{WaveletT}}}

\item{boundary}{See \code{\link[TSPred]{WaveletT}}}

\item{train_perc}{See \code{\link[TSPred]{train_test_subset}}}

\item{test_len}{See \code{\link[TSPred]{train_test_subset}}}

\item{window_len}{See \code{\link[TSPred]{sw}}}

\item{na.action}{Function for handling missing values in time series data}

\item{min}{See \code{\link[TSPred]{an}}}

\item{max}{See \code{\link[TSPred]{an}}}

\item{byRow}{See \code{\link[TSPred]{an}}}

\item{outlier.rm}{See \code{\link[TSPred]{an}}}

\item{alpha}{See \code{\link[TSPred]{an}}}

\item{lag}{See \code{\link[TSPred]{Diff}}}

\item{differences}{See \code{\link[TSPred]{Diff}}}

\item{type}{See \code{\link[TSPred]{Diff}}}

\item{order}{See \code{\link[TSPred]{mas}}}

\item{num_imfs}{See \code{\link[TSPred]{emd}}}

\item{meaningfulImfs}{See \code{\link[TSPred]{emd}}}
}
\value{
An object of class \code{processing}.
}
\description{
Constructors for the \code{processing} class representing a time series
processing method based on a particular time series transformation.
}
\section{Mapping-based nonstationary transformation methods}{

	Logarithmic transform. \code{prep_func} set as \code{\link[TSPred]{LogT}} 
 and \code{postp_func} set as \code{\link[TSPred]{LogT.rev}}.


	Box-Cox transform. \code{prep_func} set as \code{\link[TSPred]{BCT}} 
 and \code{postp_func} set as \code{\link[TSPred]{BCT.rev}}.


	Differencing. \code{prep_func} set as \code{\link[TSPred]{Diff}} 
 and \code{postp_func} set as \code{\link[TSPred]{Diff.rev}}.


	Moving average smoothing. \code{prep_func} set as \code{\link[TSPred]{mas}} 
 and \code{postp_func} set as \code{\link[TSPred]{mas.rev}}.


	Percentage change transform. \code{prep_func} set as \code{\link[TSPred]{pct}} 
 and \code{postp_func} set as \code{\link[TSPred]{pct.rev}}.
}

\section{Splitting-based nonstationary transformation methods}{

	Wavelet transform. \code{prep_func} set as \code{\link[TSPred]{WaveletT}} 
 and \code{postp_func} set as \code{\link[TSPred]{WaveletT.rev}}.


	Empirical mode decomposition. \code{prep_func} set as \code{\link[TSPred]{emd}} 
 and \code{postp_func} set as \code{\link[TSPred]{emd.rev}}.
}

\section{Data subsetting methods}{

	Subsetting data into training and testing sets. \code{prep_func} set as \code{\link[TSPred]{train_test_subset}} 
 and \code{postp_func} set to \code{NULL}.


	Sliding windows. \code{prep_func} set as \code{\link[TSPred]{sw}} 
 and \code{postp_func} set to \code{NULL}.
}

\section{Methods for handling missing values}{

	Missing values treatment. \code{prep_func} set as parameter \code{na.action}
 and \code{postp_func} set to \code{NULL}.
}

\section{Normalization methods}{

	MinMax normalization. \code{prep_func} set as \code{\link[TSPred]{minmax}} 
 and \code{postp_func} set to \code{\link[TSPred]{minmax.rev}}.


	Adaptive normalization. \code{prep_func} set as \code{\link[TSPred]{an}} 
 and \code{postp_func} set to \code{\link[TSPred]{an.rev}}.
}

\references{
R. Salles, K. Belloze, F. Porto, P.H. Gonzalez, and E. Ogasawara. 
Nonstationary time series transformation methods: An experimental review.
Knowledge-Based Systems, 164:274-291, 2019.
}
\seealso{
Other constructors: 
\code{\link{ARIMA}()},
\code{\link{MSE_eval}()},
\code{\link{evaluating}()},
\code{\link{modeling}()},
\code{\link{processing}()},
\code{\link{tspred}()}
}
\author{
Rebecca Pontes Salles
}
\concept{constructors}
\keyword{postprocessing}
\keyword{preprocessing}
\keyword{processing}
\keyword{transformation}
