% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TSDT_scoring_functions.R
\name{mean_response}
\alias{mean_response}
\title{mean_response}
\usage{
mean_response(data, scoring_function_parameters = NULL)
}
\arguments{
\item{data}{data.frame containing response data}

\item{scoring_function_parameters}{named list of scoring function control
parameters}
}
\value{
The mean of the provided response variable.
}
\description{
Compute the mean response.
}
\details{
This function will compute the mean of the response variable. If
a value for trt_arm is provided the mean in that treatment arm only will be
computed (and the trt variable must also be provided), otherwise the mean
for all data passed to the function will be computed.
}
\examples{
N <- 50

data <- data.frame( continuous_response = numeric(N),
                   trt = character(N) )

data$continuous_response <- runif( min = 0, max = 20, n = N )
data$trt <- sample( c('Control','Experimental'), size = N, prob = c(0.4,0.6), replace = TRUE )

## Compute mean response for all data
mean_response( data, scoring_function_parameters = list( y_var = 'continuous_response' ) )
mean( data$continuous_response ) # Function return value should match this value

## Compute mean response for Experimental treatment arm only
scoring_function_parameters <- list( y_var = 'continuous_response', trt_arm = 'Experimental' )
mean_response( data, scoring_function_parameters = scoring_function_parameters )
# Function return value should match this value
mean( data$continuous_response[ data$trt == 'Experimental' ] )
}
\seealso{
\link{TSDT}, \link{treatment_effect}
}
