% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dendro_plot.R
\name{dendro_plot}
\alias{dendro_plot}
\title{Dendrograms for multiple samples/groups clustering.}
\usage{
dendro_plot(
  data,
  dist_method = "euclidean",
  hc_method = "average",
  tree_type = "rectangle",
  k_num = 3,
  palette = "npg",
  color_labels_by_k = TRUE,
  horiz = TRUE,
  label_size = 0.8,
  line_width = 0.7,
  rect = TRUE,
  rect_fill = TRUE,
  title = "Cluster Dendrogram",
  xlab = "",
  ylab = "Height"
)
}
\arguments{
\item{data}{Dataframe: gene expression dataframe with cols (samples) and rows (genes).}

\item{dist_method}{Character: distance measure method. Default: "euclidean", options: "euclidean", "maximum", "manhattan", "canberra", "binary" or "minkowski".}

\item{hc_method}{Character: hierarchical clustering method. Default: "average", options: "ward.D", "ward.D2", "single", "complete","average" (= UPGMA), "mcquitty" (= WPGMA), "median" (= WPGMC) or "centroid" (= UPGMC).}

\item{tree_type}{Character: plot tree type. Default: "rectangle", options: "rectangle", "circular", "phylogenic".}

\item{k_num}{Numeric: the number of groups for cutting the tree. Default: 3.}

\item{palette}{Character: color palette used for the group. Default: "npg", options: "npg", "aaas", "lancet", "jco", "ucscgb", "uchicago", "simpsons" and "rickandmorty".}

\item{color_labels_by_k}{Logical: labels colored by group. Default: TRUE, options: TRUE or FALSE.}

\item{horiz}{Logical: horizontal dendrogram. Default: FALSE, options: TRUE or FALSE.}

\item{label_size}{Numeric: tree label size. Default: 0.8, min: 0.}

\item{line_width}{Numeric: branches and rectangle line width. Default: 0.7, min: 0.}

\item{rect}{Logical: add a rectangle around groups. Default: TRUE, options: TRUE or FALSE.}

\item{rect_fill}{Logical: fill the rectangle. Default: TRUE, options: TRUE or FALSE.}

\item{title}{Character: main plot title. Default: "Cluster Dendrogram".}

\item{xlab}{Character: title of the xlab. Default: "".}

\item{ylab}{Character: title of the ylab. Default: "Height".}
}
\value{
Plot: Dendrograms for multiple samples/groups clustering.
}
\description{
Dendrograms for multiple samples/groups clustering.
}
\examples{
# 1. Library TOmicsVis package
library(TOmicsVis)

# 2. Use example dataset gene_exp
data(gene_exp)
head(gene_exp)

# 3. Default parameters
dendro_plot(gene_exp)

# 4. Set palette = "aaas"
dendro_plot(gene_exp, palette = "aaas")

# 5. Set tree_type = "circular"
dendro_plot(gene_exp, tree_type = "circular")

}
\author{
wei dong
}
